/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core;

import io.neow3j.utils.Async;
import io.reactivex.Observable;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;

public class RemoteCall<T> {
    private Callable<T> callable;

    public RemoteCall(Callable<T> callable) {
        this.callable = callable;
    }

    public T send() throws Exception {
        return this.callable.call();
    }

    public CompletableFuture<T> sendAsync() {
        return Async.run(this::send);
    }

    public Observable<T> observable() {
        return Observable.create(subscriber -> {
            try {
                subscriber.onNext(this.send());
                subscriber.onComplete();
            }
            catch (Exception e) {
                subscriber.onError((Throwable)e);
            }
        });
    }
}

