/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.response;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.neow3j.types.ContractParameter;
import io.neow3j.types.ContractParameterType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ContractManifest {
    private static final String WILDCARD_CHAR = "*";
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="groups")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private List<ContractGroup> groups;
    @JsonProperty(value="features")
    private HashMap<Object, Object> features;
    @JsonProperty(value="supportedstandards")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private List<String> supportedStandards;
    @JsonProperty(value="abi")
    private ContractABI abi;
    @JsonProperty(value="permissions")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private List<ContractPermission> permissions;
    @JsonProperty(value="trusts")
    @JsonSerialize(using=WildcardContainerSerializer.class)
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private List<String> trusts;
    @JsonProperty(value="extra")
    private Object extra;

    public ContractManifest() {
    }

    public ContractManifest(String name, List<ContractGroup> groups, HashMap<Object, Object> features, List<String> supportedStandards, ContractABI abi, List<ContractPermission> permissions, List<String> trusts, Object extra) {
        this.name = name;
        this.groups = groups;
        this.features = features == null ? new HashMap() : features;
        this.supportedStandards = supportedStandards;
        this.abi = abi;
        this.permissions = permissions;
        this.trusts = trusts;
        this.extra = extra;
    }

    public String getName() {
        return this.name;
    }

    public List<ContractGroup> getGroups() {
        return this.groups;
    }

    public HashMap<Object, Object> getFeatures() {
        return this.features;
    }

    public List<String> getSupportedStandards() {
        return this.supportedStandards;
    }

    public ContractABI getAbi() {
        return this.abi;
    }

    public List<ContractPermission> getPermissions() {
        return this.permissions;
    }

    public List<String> getTrusts() {
        return this.trusts;
    }

    public Object getExtra() {
        return this.extra;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContractManifest)) {
            return false;
        }
        ContractManifest that = (ContractManifest)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getGroups(), that.getGroups()) && Objects.equals(this.getFeatures(), that.getFeatures()) && Objects.equals(this.getAbi(), that.getAbi()) && Objects.equals(this.getPermissions(), that.getPermissions()) && Objects.equals(this.getTrusts(), that.getTrusts()) && Objects.equals(this.getSupportedStandards(), that.getSupportedStandards()) && Objects.equals(this.getExtra(), that.getExtra());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getGroups(), this.getFeatures(), this.getAbi(), this.getPermissions(), this.getTrusts(), this.getSupportedStandards(), this.getExtra());
    }

    public String toString() {
        return "ContractManifest{name=" + this.name + ", groups=" + this.groups + ", features=" + this.features + ", abi=" + this.abi + ", permissions=" + this.permissions + ", trusts=" + this.trusts + ", supportedStandards=" + this.supportedStandards + ", extra=" + this.extra + '}';
    }

    private static class WildcardContainerSerializer
    extends JsonSerializer<List<String>> {
        private WildcardContainerSerializer() {
        }

        public void serialize(List<String> container, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (!container.isEmpty() && container.get(0).equals(ContractManifest.WILDCARD_CHAR)) {
                jgen.writeString(ContractManifest.WILDCARD_CHAR);
                return;
            }
            jgen.writeStartArray();
            for (String value : container) {
                jgen.writeString(value);
            }
            jgen.writeEndArray();
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ContractPermission {
        @JsonProperty(value="contract")
        private String contract;
        @JsonProperty(value="methods")
        @JsonSerialize(using=WildcardContainerSerializer.class)
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
        private List<String> methods;

        public ContractPermission() {
        }

        public ContractPermission(String contract, List<String> methods) {
            this.contract = contract;
            this.methods = methods;
        }

        public String getContract() {
            return this.contract;
        }

        public List<String> getMethods() {
            return this.methods;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ContractPermission)) {
                return false;
            }
            ContractPermission that = (ContractPermission)o;
            return Objects.equals(this.getContract(), that.getContract()) && Objects.equals(this.getMethods(), that.getMethods());
        }

        public int hashCode() {
            return Objects.hash(this.getContract(), this.getMethods());
        }

        public String toString() {
            return "ContractPermission{contract=" + this.contract + ", methods=" + this.methods + '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ContractABI {
        @JsonProperty(value="methods")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private List<ContractMethod> methods;
        @JsonProperty(value="events")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private List<ContractEvent> events;

        public ContractABI() {
        }

        public ContractABI(List<ContractMethod> methods, List<ContractEvent> events) {
            this.methods = methods != null ? methods : new ArrayList();
            this.events = events != null ? events : new ArrayList();
        }

        public List<ContractMethod> getMethods() {
            return this.methods;
        }

        public List<ContractEvent> getEvents() {
            return this.events;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ContractABI)) {
                return false;
            }
            ContractABI that = (ContractABI)o;
            return Objects.equals(this.getMethods(), that.getMethods()) && Objects.equals(this.getEvents(), that.getEvents());
        }

        public int hashCode() {
            return Objects.hash(this.getMethods(), this.getEvents());
        }

        public String toString() {
            return "ContractABI{methods=" + this.methods + ", events=" + this.events + '}';
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class ContractEvent {
            @JsonProperty(value="name")
            private String name;
            @JsonProperty(value="parameters")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            private List<ContractParameter> parameters;

            public ContractEvent() {
            }

            public ContractEvent(String name, List<ContractParameter> parameters) {
                this.name = name;
                this.parameters = parameters != null ? parameters : new ArrayList();
            }

            public String getName() {
                return this.name;
            }

            public List<ContractParameter> getParameters() {
                return this.parameters;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof ContractEvent)) {
                    return false;
                }
                ContractEvent that = (ContractEvent)o;
                return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getParameters(), that.getParameters());
            }

            public int hashCode() {
                return Objects.hash(this.getName(), this.getParameters());
            }

            public String toString() {
                return "ContractEvent{name='" + this.name + '\'' + ", parameters=" + this.parameters + '}';
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class ContractMethod {
            @JsonProperty(value="name")
            private String name;
            @JsonProperty(value="parameters")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            private List<ContractParameter> parameters;
            @JsonProperty(value="offset")
            private int offset;
            @JsonProperty(value="returntype")
            private ContractParameterType returnType;
            @JsonProperty(value="safe")
            private boolean safe;

            public ContractMethod() {
            }

            public ContractMethod(String name, List<ContractParameter> parameters, int offset, ContractParameterType returnType, boolean safe) {
                this.name = name;
                this.parameters = parameters != null ? parameters : new ArrayList();
                this.offset = offset;
                this.returnType = returnType;
                this.safe = safe;
            }

            public String getName() {
                return this.name;
            }

            public List<ContractParameter> getParameters() {
                return this.parameters;
            }

            public int getOffset() {
                return this.offset;
            }

            public ContractParameterType getReturnType() {
                return this.returnType;
            }

            public boolean isSafe() {
                return this.safe;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof ContractMethod)) {
                    return false;
                }
                ContractMethod that = (ContractMethod)o;
                return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getParameters(), that.getParameters()) && this.getOffset() == that.getOffset() && this.getReturnType() == that.getReturnType() && this.isSafe() == that.isSafe();
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.getName(), this.getParameters(), this.getOffset(), this.getReturnType(), this.isSafe()});
            }

            public String toString() {
                return "ContractMethod{name='" + this.name + '\'' + ", parameters=" + this.parameters + ", offset=" + this.offset + ", returnType=" + (Object)((Object)this.returnType) + ", safe=" + this.safe + '}';
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ContractGroup {
        @JsonProperty(value="pubKey")
        @JsonAlias(value={"pubkey"})
        private String pubKey;
        @JsonProperty(value="signature")
        private String signature;

        public ContractGroup() {
        }

        public ContractGroup(String pubKey, String signature) {
            this.pubKey = pubKey;
            this.signature = signature;
        }

        public String getPubKey() {
            return this.pubKey;
        }

        public String getSignature() {
            return this.signature;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ContractGroup)) {
                return false;
            }
            ContractGroup that = (ContractGroup)o;
            return Objects.equals(this.getPubKey(), that.getPubKey()) && Objects.equals(this.getSignature(), that.getSignature());
        }

        public int hashCode() {
            return Objects.hash(this.getPubKey(), this.getSignature());
        }

        public String toString() {
            return "ContractGroup{pubKey=" + this.pubKey + ", signature=" + this.signature + '}';
        }
    }
}

