/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.neow3j.protocol.core.stackitem.StackItem;
import io.neow3j.types.ContractParameter;
import io.neow3j.types.NeoVMStateType;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InvocationResult {
    @JsonProperty(value="script")
    private String script;
    @JsonProperty(value="state")
    private NeoVMStateType state;
    @JsonProperty(value="gasconsumed")
    private String gasConsumed;
    @JsonProperty(value="exception")
    private String exception;
    @JsonProperty(value="stack")
    private List<StackItem> stack;
    @JsonProperty(value="tx")
    private String tx;
    @JsonProperty(value="pendingsignature")
    private PendingSignature pendingSignature;

    public InvocationResult() {
    }

    public InvocationResult(String script, NeoVMStateType state, String gasConsumed, String exception, List<StackItem> stack, String tx, PendingSignature pendingSignature) {
        this.script = script;
        this.state = state;
        this.gasConsumed = gasConsumed;
        this.exception = exception;
        this.stack = stack;
        this.tx = tx;
        this.pendingSignature = pendingSignature;
    }

    public String getScript() {
        return this.script;
    }

    public NeoVMStateType getState() {
        return this.state;
    }

    public boolean hasStateFault() {
        return this.state == NeoVMStateType.FAULT;
    }

    public String getGasConsumed() {
        return this.gasConsumed;
    }

    public String getException() {
        return this.exception;
    }

    public List<StackItem> getStack() {
        return this.stack;
    }

    public String getTx() {
        return this.tx;
    }

    public PendingSignature getPendingSignature() {
        return this.pendingSignature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvocationResult)) {
            return false;
        }
        InvocationResult that = (InvocationResult)o;
        return Objects.equals(this.getScript(), that.getScript()) && Objects.equals((Object)this.getState(), (Object)that.getState()) && Objects.equals(this.getGasConsumed(), that.getGasConsumed()) && Objects.equals(this.getException(), that.getException()) && Objects.equals(this.getStack(), that.getStack()) && Objects.equals(this.getTx(), that.getTx()) && Objects.equals(this.getPendingSignature(), that.getPendingSignature());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getScript(), this.getState(), this.getGasConsumed(), this.getException(), this.getStack(), this.getTx(), this.getPendingSignature()});
    }

    public String toString() {
        return "InvocationResult{script='" + this.script + '\'' + ", state=" + (Object)((Object)this.state) + ", gasconsumed=" + this.gasConsumed + ", exception='" + this.exception + '\'' + ", stack=" + this.stack + ", tx='" + this.tx + '\'' + ", pendingsignature='" + this.pendingSignature + '\'' + '}';
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PendingSignature {
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="data")
        private String data;
        @JsonProperty(value="items")
        Map<String, Item> items;
        @JsonProperty(value="network")
        private long network;

        public PendingSignature() {
        }

        public PendingSignature(String type, String data, Map<String, Item> items, long network) {
            this.type = type;
            this.data = data;
            this.items = items;
            this.network = network;
        }

        public String getType() {
            return this.type;
        }

        public String getData() {
            return this.data;
        }

        public Map<String, Item> getItems() {
            return this.items;
        }

        public long getNetwork() {
            return this.network;
        }

        public static class Item {
            @JsonProperty(value="script")
            private String script;
            @JsonProperty(value="parameters")
            private List<ContractParameter> parameters;
            @JsonProperty(value="signatures")
            private Map<String, String> signatures;

            public Item() {
            }

            public Item(String script, List<ContractParameter> parameters, Map<String, String> signatures) {
                this.script = script;
                this.parameters = parameters;
                this.signatures = signatures;
            }

            public String getScript() {
                return this.script;
            }

            public List<ContractParameter> getParameters() {
                return this.parameters;
            }

            public Map<String, String> getSignatures() {
                return this.signatures;
            }
        }
    }
}

