/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.neow3j.crypto.ECKeyPair;
import java.math.BigInteger;
import java.util.Objects;

public class NeoAccountState {
    @JsonProperty(value="balance")
    private BigInteger balance;
    @JsonProperty(value="balanceHeight")
    private BigInteger balanceHeight;
    @JsonProperty(value="voteTo")
    private ECKeyPair.ECPublicKey publicKey;

    public NeoAccountState() {
    }

    public NeoAccountState(BigInteger balance, BigInteger balanceHeight, ECKeyPair.ECPublicKey publicKey) {
        this.balance = balance;
        this.balanceHeight = balanceHeight;
        this.publicKey = publicKey;
    }

    public static NeoAccountState withNoVote(BigInteger balance, BigInteger updateHeight) {
        return new NeoAccountState(balance, updateHeight, null);
    }

    public static NeoAccountState withNoBalance() {
        return new NeoAccountState(BigInteger.ZERO, null, null);
    }

    public BigInteger getBalance() {
        return this.balance;
    }

    public BigInteger getBalanceHeight() {
        return this.balanceHeight;
    }

    public ECKeyPair.ECPublicKey getPublicKey() {
        return this.publicKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NeoAccountState)) {
            return false;
        }
        NeoAccountState that = (NeoAccountState)o;
        return Objects.equals(this.getBalance(), that.getBalance()) && Objects.equals(this.getBalanceHeight(), that.getBalanceHeight()) && Objects.equals(this.getPublicKey(), that.getPublicKey());
    }

    public int hashCode() {
        return Objects.hash(this.getBalance(), this.getBalanceHeight(), this.getPublicKey());
    }

    public String toString() {
        return "NeoAccountState{balance=" + this.getBalance().toString() + ", updateHeight=" + this.getBalanceHeight() + ", voteTo=" + this.getPublicKey() + "}";
    }
}

