/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import io.neow3j.protocol.core.response.NeoWitness;
import io.neow3j.protocol.core.response.Transaction;
import io.neow3j.types.Hash256;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NeoBlock {
    @JsonProperty(value="hash")
    private Hash256 hash;
    @JsonProperty(value="size")
    private long size;
    @JsonProperty(value="version")
    private int version;
    @JsonProperty(value="previousblockhash")
    private Hash256 prevBlockHash;
    @JsonProperty(value="merkleroot")
    private Hash256 merkleRootHash;
    @JsonProperty(value="time")
    private long time;
    @JsonProperty(value="index")
    private long index;
    @JsonProperty(value="primary")
    private int primary;
    @JsonProperty(value="nextconsensus")
    private String nextConsensus;
    @JsonProperty(value="witnesses")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private List<NeoWitness> witnesses;
    @JsonProperty(value="tx")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<Transaction> transactions;
    @JsonProperty(value="confirmations")
    private int confirmations;
    @JsonProperty(value="nextblockhash")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Hash256 nextBlockHash;

    public NeoBlock() {
    }

    public NeoBlock(Hash256 hash, long size, int version, Hash256 prevBlockHash, Hash256 merkleRootHash, long time, long index, int primary, String nextConsensus, List<NeoWitness> witnesses, List<Transaction> transactions, int confirmations, Hash256 nextBlockHash) {
        this.hash = hash;
        this.size = size;
        this.version = version;
        this.prevBlockHash = prevBlockHash;
        this.merkleRootHash = merkleRootHash;
        this.time = time;
        this.index = index;
        this.primary = primary;
        this.nextConsensus = nextConsensus;
        this.witnesses = witnesses;
        this.transactions = transactions;
        this.confirmations = confirmations;
        this.nextBlockHash = nextBlockHash;
    }

    public Hash256 getHash() {
        return this.hash;
    }

    public long getSize() {
        return this.size;
    }

    public int getVersion() {
        return this.version;
    }

    public Hash256 getPrevBlockHash() {
        return this.prevBlockHash;
    }

    public Hash256 getMerkleRootHash() {
        return this.merkleRootHash;
    }

    public long getTime() {
        return this.time;
    }

    public long getIndex() {
        return this.index;
    }

    public int getPrimary() {
        return this.primary;
    }

    public String getNextConsensus() {
        return this.nextConsensus;
    }

    public List<NeoWitness> getWitnesses() {
        return this.witnesses;
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public int getConfirmations() {
        return this.confirmations;
    }

    public Hash256 getNextBlockHash() {
        return this.nextBlockHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NeoBlock)) {
            return false;
        }
        NeoBlock neoBlock = (NeoBlock)o;
        return this.getSize() == neoBlock.getSize() && this.getVersion() == neoBlock.getVersion() && this.getTime() == neoBlock.getTime() && this.getIndex() == neoBlock.getIndex() && this.getConfirmations() == neoBlock.getConfirmations() && this.getPrimary() == neoBlock.getPrimary() && Objects.equals(this.getHash(), neoBlock.getHash()) && Objects.equals(this.getPrevBlockHash(), neoBlock.getPrevBlockHash()) && Objects.equals(this.getMerkleRootHash(), neoBlock.getMerkleRootHash()) && Objects.equals(this.getNextConsensus(), neoBlock.getNextConsensus()) && Objects.equals(this.getWitnesses(), neoBlock.getWitnesses()) && Objects.equals(this.getTransactions(), neoBlock.getTransactions()) && Objects.equals(this.getNextBlockHash(), neoBlock.getNextBlockHash());
    }

    public int hashCode() {
        return Objects.hash(this.getHash(), this.getSize(), this.getVersion(), this.getPrevBlockHash(), this.getMerkleRootHash(), this.getTime(), this.getIndex(), this.getPrimary(), this.getNextConsensus(), this.getWitnesses(), this.getTransactions(), this.getConfirmations(), this.getNextBlockHash());
    }

    public String toString() {
        return "NeoBlock{hash='" + this.hash + '\'' + ", size=" + this.size + ", version=" + this.version + ", prevBlockHash='" + this.prevBlockHash + '\'' + ", merkleRootHash='" + this.merkleRootHash + '\'' + ", time=" + this.time + ", index=" + this.index + ", primary=" + this.primary + ", nextConsensus='" + this.nextConsensus + '\'' + ", witnesses=" + this.witnesses + ", transactions=" + this.transactions + ", confirmations=" + this.confirmations + ", nextBlockHash='" + this.nextBlockHash + '\'' + '}';
    }
}

