/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import io.neow3j.protocol.core.Response;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;

public class NeoGetClaimable
extends Response<Claimables> {
    public Claimables getClaimables() {
        return (Claimables)this.getResult();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Claim {
        @JsonProperty(value="txid")
        private String txId;
        @JsonProperty(value="n")
        private int index;
        @JsonProperty(value="value")
        private BigInteger neoValue;
        @JsonProperty(value="start_height")
        private BigInteger startHeight;
        @JsonProperty(value="end_height")
        private BigInteger endHeight;
        @JsonProperty(value="generated")
        private String generatedGas;
        @JsonProperty(value="sysfee")
        private String systemFee;
        @JsonProperty(value="unclaimed")
        private String unclaimedGas;

        public Claim() {
        }

        public Claim(String txId, int index, BigInteger neoValue, BigInteger startHeight, BigInteger endHeight, String generatedGas, String systemFee, String unclaimedGas) {
            this.txId = txId;
            this.index = index;
            this.neoValue = neoValue;
            this.startHeight = startHeight;
            this.endHeight = endHeight;
            this.generatedGas = generatedGas;
            this.systemFee = systemFee;
            this.unclaimedGas = unclaimedGas;
        }

        public String getTxId() {
            return this.txId;
        }

        public int getIndex() {
            return this.index;
        }

        public BigInteger getNeoValue() {
            return this.neoValue;
        }

        public BigInteger getStartHeight() {
            return this.startHeight;
        }

        public BigInteger getEndHeight() {
            return this.endHeight;
        }

        public String getGeneratedGas() {
            return this.generatedGas;
        }

        public String getSystemFee() {
            return this.systemFee;
        }

        public String getUnclaimedGas() {
            return this.unclaimedGas;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Claim claim = (Claim)o;
            return this.index == claim.getIndex() && this.startHeight.compareTo(claim.getStartHeight()) == 0 && this.endHeight.compareTo(claim.getEndHeight()) == 0 && Objects.equals(this.txId, claim.getTxId()) && this.neoValue.compareTo(claim.getNeoValue()) == 0 && Objects.equals(this.generatedGas, claim.getGeneratedGas()) && Objects.equals(this.systemFee, claim.getSystemFee()) && Objects.equals(this.unclaimedGas, claim.getUnclaimedGas());
        }

        public int hashCode() {
            return Objects.hash(this.txId, this.index, this.neoValue, this.startHeight, this.endHeight, this.generatedGas, this.systemFee, this.unclaimedGas);
        }

        public String toString() {
            return "Claim{txId='" + this.txId + '\'' + ", index=" + this.index + ", neoValue=" + this.neoValue + ", startHeight=" + this.startHeight + ", endHeight=" + this.endHeight + ", generatedGas=" + this.generatedGas + ", systemFee=" + this.systemFee + ", unclaimedGas=" + this.unclaimedGas + '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Claimables {
        @JsonProperty(value="claimable")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private List<Claim> claims;
        @JsonProperty(value="address")
        private String address;
        @JsonProperty(value="unclaimed")
        private String totalUnclaimed;

        public Claimables() {
        }

        public Claimables(List<Claim> claims, String address, String totalUnclaimed) {
            this.claims = claims;
            this.address = address;
            this.totalUnclaimed = totalUnclaimed;
        }

        public List<Claim> getClaims() {
            return this.claims;
        }

        public String getAddress() {
            return this.address;
        }

        public String getTotalUnclaimed() {
            return this.totalUnclaimed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Claimables that = (Claimables)o;
            return Objects.equals(this.claims, that.claims) && Objects.equals(this.address, that.address) && Objects.equals(this.totalUnclaimed, that.getTotalUnclaimed());
        }

        public int hashCode() {
            return Objects.hash(this.claims, this.address, this.totalUnclaimed);
        }

        public String toString() {
            return "Claimables{claims=" + this.claims + ", address='" + this.address + '\'' + ", totalUnclaimed=" + this.totalUnclaimed + '}';
        }
    }
}

