/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import io.neow3j.protocol.core.response.NeoGetTokenBalances;
import io.neow3j.types.Hash160;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;

public class NeoGetNep11Balances
extends NeoGetTokenBalances<Nep11Balances> {
    public Nep11Balances getBalances() {
        return (Nep11Balances)this.getResult();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Nep11Balance
    extends NeoGetTokenBalances.TokenBalance {
        @JsonProperty(value="tokens")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private List<Nep11Token> tokens;

        public Nep11Balance() {
        }

        public Nep11Balance(Hash160 assetHash, List<Nep11Token> tokens) {
            super(assetHash);
            this.tokens = tokens;
        }

        public List<Nep11Token> getTokens() {
            return this.tokens;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Nep11Balance)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Nep11Balance that = (Nep11Balance)o;
            return Objects.equals(this.tokens, that.tokens);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.tokens);
        }

        public static class Nep11Token {
            @JsonProperty(value="tokenid")
            private String tokenId;
            @JsonProperty(value="amount")
            private BigInteger amount;
            @JsonProperty(value="lastupdatedblock")
            private Long lastUpdatedBlock;

            public Nep11Token() {
            }

            public Nep11Token(String tokenId, BigInteger amount, Long lastUpdatedBlock) {
                this.tokenId = tokenId;
                this.amount = amount;
                this.lastUpdatedBlock = lastUpdatedBlock;
            }

            public String getTokenId() {
                return this.tokenId;
            }

            public BigInteger getAmount() {
                return this.amount;
            }

            public Long getLastUpdatedBlock() {
                return this.lastUpdatedBlock;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Nep11Token)) {
                    return false;
                }
                Nep11Token that = (Nep11Token)o;
                return Objects.equals(this.tokenId, that.tokenId) && Objects.equals(this.amount, that.amount) && Objects.equals(this.lastUpdatedBlock, that.lastUpdatedBlock);
            }

            public int hashCode() {
                return Objects.hash(this.tokenId, this.amount, this.lastUpdatedBlock);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Nep11Balances
    extends NeoGetTokenBalances.TokenBalances<Nep11Balance> {
        public Nep11Balances() {
        }

        public Nep11Balances(List<Nep11Balance> balances, String address) {
            super(balances, address);
        }
    }
}

