/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.neow3j.protocol.core.Response;
import io.neow3j.protocol.core.response.NeoWitness;
import io.neow3j.types.Hash256;
import java.util.List;
import java.util.Objects;

public class NeoGetStateRoot
extends Response<StateRoot> {
    public StateRoot getStateRoot() {
        return (StateRoot)this.getResult();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class StateRoot {
        @JsonProperty(value="version")
        private int version;
        @JsonProperty(value="index")
        private long index;
        @JsonProperty(value="roothash")
        private Hash256 rootHash;
        @JsonProperty(value="witnesses")
        private List<NeoWitness> witness;

        public StateRoot() {
        }

        public StateRoot(int version, long index, Hash256 rootHash, List<NeoWitness> witness) {
            this.version = version;
            this.index = index;
            this.rootHash = rootHash;
            this.witness = witness;
        }

        public int getVersion() {
            return this.version;
        }

        public long getIndex() {
            return this.index;
        }

        public Hash256 getRootHash() {
            return this.rootHash;
        }

        public List<NeoWitness> getWitnesses() {
            return this.witness;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StateRoot)) {
                return false;
            }
            StateRoot that = (StateRoot)o;
            return this.getVersion() == that.getVersion() && this.getIndex() == that.getIndex() && Objects.equals(this.getRootHash(), that.getRootHash()) && Objects.equals(this.getWitnesses(), that.getWitnesses());
        }

        public int hashCode() {
            return Objects.hash(this.getVersion(), this.getIndex(), this.getRootHash(), this.getWitnesses());
        }

        public String toString() {
            return "StateRoot{version=" + this.version + ", index=" + this.index + ", rootHash='" + this.rootHash + '\'' + ", witness=" + this.witness + '}';
        }
    }
}

