/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import io.neow3j.protocol.core.Response;
import io.neow3j.types.Hash160;
import java.util.List;
import java.util.Objects;

public class NeoGetTokenBalances<T extends TokenBalances<? extends TokenBalance>>
extends Response<T> {

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TokenBalance {
        @JsonProperty(value="assethash")
        private Hash160 assetHash;

        public TokenBalance() {
        }

        public TokenBalance(Hash160 assetHash) {
            this.assetHash = assetHash;
        }

        public Hash160 getAssetHash() {
            return this.assetHash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TokenBalance)) {
                return false;
            }
            TokenBalance that = (TokenBalance)o;
            return Objects.equals(this.assetHash, that.assetHash);
        }

        public int hashCode() {
            return Objects.hash(this.assetHash);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TokenBalances<K extends TokenBalance> {
        @JsonProperty(value="balance")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private List<K> balances;
        @JsonProperty(value="address")
        private String address;

        public TokenBalances() {
        }

        public TokenBalances(List<K> balances, String address) {
            this.balances = balances;
            this.address = address;
        }

        public List<K> getBalances() {
            return this.balances;
        }

        public String getAddress() {
            return this.address;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TokenBalances)) {
                return false;
            }
            TokenBalances that = (TokenBalances)o;
            return Objects.equals(this.balances, that.balances) && Objects.equals(this.address, that.address);
        }

        public int hashCode() {
            return Objects.hash(this.balances, this.address);
        }
    }
}

