/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import io.neow3j.protocol.core.Response;
import io.neow3j.types.Hash160;
import io.neow3j.types.Hash256;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;

public abstract class NeoGetTokenTransfers<T extends TokenTransfers>
extends Response<T> {

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TokenTransfer {
        @JsonProperty(value="timestamp")
        private long timestamp;
        @JsonProperty(value="assethash")
        private Hash160 assetHash;
        @JsonProperty(value="transferaddress")
        private String transferAddress;
        @JsonProperty(value="amount")
        private BigInteger amount;
        @JsonProperty(value="blockindex")
        private long blockIndex;
        @JsonProperty(value="transfernotifyindex")
        private long transferNotifyIndex;
        @JsonProperty(value="txhash")
        private Hash256 txHash;

        public TokenTransfer() {
        }

        public TokenTransfer(long timestamp, Hash160 assetHash, String transferAddress, BigInteger amount, long blockIndex, long transferNotifyIndex, Hash256 txHash) {
            this.timestamp = timestamp;
            this.assetHash = assetHash;
            this.transferAddress = transferAddress;
            this.amount = amount;
            this.blockIndex = blockIndex;
            this.transferNotifyIndex = transferNotifyIndex;
            this.txHash = txHash;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public Hash160 getAssetHash() {
            return this.assetHash;
        }

        public String getTransferAddress() {
            return this.transferAddress;
        }

        public BigInteger getAmount() {
            return this.amount;
        }

        public long getBlockIndex() {
            return this.blockIndex;
        }

        public long getTransferNotifyIndex() {
            return this.transferNotifyIndex;
        }

        public Hash256 getTxHash() {
            return this.txHash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TokenTransfer)) {
                return false;
            }
            TokenTransfer that = (TokenTransfer)o;
            return this.timestamp == that.timestamp && this.blockIndex == that.blockIndex && this.transferNotifyIndex == that.transferNotifyIndex && Objects.equals(this.assetHash, that.assetHash) && Objects.equals(this.transferAddress, that.transferAddress) && Objects.equals(this.amount, that.amount) && Objects.equals(this.txHash, that.txHash);
        }

        public int hashCode() {
            return Objects.hash(this.timestamp, this.assetHash, this.transferAddress, this.amount, this.blockIndex, this.transferNotifyIndex, this.txHash);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TokenTransfers<K extends TokenTransfer> {
        @JsonProperty(value="sent")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private List<K> sent;
        @JsonProperty(value="received")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private List<K> received;
        @JsonProperty(value="address")
        private String transferAddress;

        public TokenTransfers() {
        }

        public TokenTransfers(List<K> sent, List<K> received, String transferAddress) {
            this.sent = sent;
            this.received = received;
            this.transferAddress = transferAddress;
        }

        public List<K> getSent() {
            return this.sent;
        }

        public List<K> getReceived() {
            return this.received;
        }

        public String getTransferAddress() {
            return this.transferAddress;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TokenTransfers)) {
                return false;
            }
            TokenTransfers that = (TokenTransfers)o;
            return Objects.equals(this.sent, that.sent) && Objects.equals(this.received, that.received) && Objects.equals(this.transferAddress, that.transferAddress);
        }

        public int hashCode() {
            return Objects.hash(this.sent, this.received, this.transferAddress);
        }
    }
}

