/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import io.neow3j.protocol.core.Response;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

public class NeoGetUnspents
extends Response<Unspents> {
    public Unspents getUnspents() {
        return (Unspents)this.getResult();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class UnspentTransaction {
        @JsonProperty(value="txid")
        private String txId;
        @JsonProperty(value="n")
        private Integer index;
        @JsonProperty(value="value")
        private BigDecimal value;

        public UnspentTransaction() {
        }

        public UnspentTransaction(String txId, Integer index, BigDecimal value) {
            this.txId = txId;
            this.index = index;
            this.value = value;
        }

        public String getTxId() {
            return this.txId;
        }

        public Integer getIndex() {
            return this.index;
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnspentTransaction)) {
                return false;
            }
            UnspentTransaction that = (UnspentTransaction)o;
            return Objects.equals(this.getTxId(), that.getTxId()) && Objects.equals(this.getIndex(), that.getIndex()) && Objects.equals(this.getValue(), that.getValue());
        }

        public int hashCode() {
            return Objects.hash(this.getTxId(), this.getIndex(), this.getValue());
        }

        public String toString() {
            return "UnspentTransaction{txId='" + this.txId + '\'' + ", index=" + this.index + ", value=" + this.value + '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Balance {
        @JsonProperty(value="unspent")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private List<UnspentTransaction> unspentTransactions;
        @JsonProperty(value="assethash")
        private String assetHash;
        @JsonProperty(value="asset")
        private String assetName;
        @JsonProperty(value="asset_symbol")
        private String assetSymbol;
        @JsonProperty(value="amount")
        private BigDecimal amount;

        public Balance() {
        }

        public Balance(List<UnspentTransaction> unspentTransactions, String assetHash, String assetName, String assetSymbol, BigDecimal amount) {
            this.unspentTransactions = unspentTransactions;
            this.assetHash = assetHash;
            this.assetName = assetName;
            this.assetSymbol = assetSymbol;
            this.amount = amount;
        }

        public List<UnspentTransaction> getUnspentTransactions() {
            return this.unspentTransactions;
        }

        public String getAssetHash() {
            return this.assetHash;
        }

        public String getAssetName() {
            return this.assetName;
        }

        public String getAssetSymbol() {
            return this.assetSymbol;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Balance)) {
                return false;
            }
            Balance balance = (Balance)o;
            return Objects.equals(this.getUnspentTransactions(), balance.getUnspentTransactions()) && Objects.equals(this.getAssetHash(), balance.getAssetHash()) && Objects.equals(this.getAssetName(), balance.getAssetName()) && Objects.equals(this.getAssetSymbol(), balance.getAssetSymbol()) && Objects.equals(this.getAmount(), balance.getAmount());
        }

        public int hashCode() {
            return Objects.hash(this.getUnspentTransactions(), this.getAssetHash(), this.getAssetName(), this.getAssetSymbol(), this.getAmount());
        }

        public String toString() {
            return "Balance{unspentTransactions=" + this.unspentTransactions + ", assetHash='" + this.assetHash + '\'' + ", assetName='" + this.assetName + '\'' + ", assetSymbol='" + this.assetSymbol + '\'' + ", amount=" + this.amount + '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Unspents {
        @JsonProperty(value="balance")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private List<Balance> balances;
        @JsonProperty(value="address")
        private String address;

        public Unspents() {
        }

        public Unspents(List<Balance> balances, String address) {
            this.balances = balances;
            this.address = address;
        }

        public List<Balance> getBalances() {
            return this.balances;
        }

        public String getAddress() {
            return this.address;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Unspents)) {
                return false;
            }
            Unspents unspents = (Unspents)o;
            return Objects.equals(this.getBalances(), unspents.getBalances()) && Objects.equals(this.getAddress(), unspents.getAddress());
        }

        public int hashCode() {
            return Objects.hash(this.getBalances(), this.getAddress());
        }

        public String toString() {
            return "Unspents{balances=" + this.balances + ", address='" + this.address + '\'' + '}';
        }
    }
}

