/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.neow3j.crypto.Base64;
import io.neow3j.transaction.Witness;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NeoWitness {
    @JsonProperty(value="invocation")
    private String invocation;
    @JsonProperty(value="verification")
    private String verification;

    public NeoWitness() {
    }

    public NeoWitness(String invocation, String verification) {
        this.invocation = invocation;
        this.verification = verification;
    }

    public NeoWitness(Witness witness) {
        this.verification = Base64.encode(witness.getVerificationScript().getScript());
        this.invocation = Base64.encode(witness.getInvocationScript().getScript());
    }

    public String getInvocation() {
        return this.invocation;
    }

    public String getVerification() {
        return this.verification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NeoWitness)) {
            return false;
        }
        NeoWitness script = (NeoWitness)o;
        return Objects.equals(this.getInvocation(), script.getInvocation()) && Objects.equals(this.getVerification(), script.getVerification());
    }

    public int hashCode() {
        return Objects.hash(this.getInvocation(), this.getVerification());
    }

    public String toString() {
        return "Script{invocation='" + this.invocation + '\'' + ", verification='" + this.verification + '\'' + '}';
    }
}

