/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.neow3j.types.Hash160;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Nep17Contract {
    @JsonProperty(value="scriptHash")
    private Hash160 scriptHash;
    @JsonProperty(value="symbol")
    private String symbol;
    @JsonProperty(value="decimals")
    private int decimals;

    public Nep17Contract() {
    }

    public Nep17Contract(Hash160 scriptHash, String symbol, int decimals) {
        this.scriptHash = scriptHash;
        this.symbol = symbol;
        this.decimals = decimals;
    }

    public Hash160 getScriptHash() {
        return this.scriptHash;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public int hashCode() {
        return Objects.hash(this.getScriptHash(), this.getSymbol(), this.getDecimals());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Nep17Contract)) {
            return false;
        }
        Nep17Contract that = (Nep17Contract)o;
        return Objects.equals(this.getScriptHash(), that.getScriptHash()) && Objects.equals(this.getSymbol(), that.getSymbol()) && Objects.equals(this.getDecimals(), that.getDecimals());
    }

    public String toString() {
        return "Nep17Contract{scriptHash='" + this.scriptHash + "', symbol='" + this.symbol + "', decimals=" + this.decimals + '}';
    }
}

