/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.neow3j.types.Hash160;
import io.neow3j.types.Hash256;
import java.math.BigInteger;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OracleRequest {
    @JsonProperty(value="requestid")
    private BigInteger requestId;
    @JsonProperty(value="originaltxid")
    private Hash256 originalTransactionHash;
    @JsonProperty(value="gasforresponse")
    private BigInteger gasForResponse;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="filter")
    private String filter;
    @JsonProperty(value="callbackcontract")
    private Hash160 callbackContract;
    @JsonProperty(value="callbackmethod")
    private String callbackMethod;
    @JsonProperty(value="userdata")
    private String userData;

    public OracleRequest() {
    }

    public OracleRequest(BigInteger requestId, Hash256 originalTransactionHash, BigInteger gasForResponse, String url, String filter, Hash160 callbackContract, String callbackMethod, String userData) {
        this.requestId = requestId;
        this.originalTransactionHash = originalTransactionHash;
        this.gasForResponse = gasForResponse;
        this.url = url;
        this.filter = filter;
        this.callbackContract = callbackContract;
        this.callbackMethod = callbackMethod;
        this.userData = userData;
    }

    public BigInteger getRequestId() {
        return this.requestId;
    }

    public Hash256 getOriginalTransactionHash() {
        return this.originalTransactionHash;
    }

    public BigInteger getGasForResponse() {
        return this.gasForResponse;
    }

    public String getUrl() {
        return this.url;
    }

    public String getFilter() {
        return this.filter;
    }

    public Hash160 getCallbackContract() {
        return this.callbackContract;
    }

    public String getCallbackMethod() {
        return this.callbackMethod;
    }

    public String getUserData() {
        return this.userData;
    }

    public int hashCode() {
        return Objects.hash(this.getRequestId(), this.getOriginalTransactionHash(), this.getGasForResponse(), this.getUrl(), this.getFilter(), this.getCallbackContract(), this.getCallbackMethod(), this.getUserData());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OracleRequest)) {
            return false;
        }
        OracleRequest that = (OracleRequest)o;
        return Objects.equals(this.getRequestId(), that.getRequestId()) && Objects.equals(this.getOriginalTransactionHash(), that.getOriginalTransactionHash()) && Objects.equals(this.getGasForResponse(), that.getGasForResponse()) && Objects.equals(this.getUrl(), that.getUrl()) && Objects.equals(this.getFilter(), that.getFilter()) && Objects.equals(this.getCallbackContract(), that.getCallbackContract()) && Objects.equals(this.getCallbackMethod(), that.getCallbackMethod()) && Objects.equals(this.getUserData(), that.getUserData());
    }

    public String toString() {
        return "OracleResponse{requestId=" + this.requestId + ", originalTxHash='" + this.originalTransactionHash + "', gasForResponse=" + this.gasForResponse + ", url='" + this.url + "', filter='" + this.filter + "', callbackContract='" + this.callbackContract + "', callbackMethod='" + this.callbackMethod + "', userData='" + this.userData + "'" + '}';
    }
}

