/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.neow3j.types.Hash160;
import java.math.BigInteger;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TransactionSendToken {
    @JsonProperty(value="asset")
    private Hash160 token;
    @JsonProperty(value="value")
    private BigInteger value;
    @JsonProperty(value="address")
    private String address;

    public TransactionSendToken() {
    }

    public TransactionSendToken(Hash160 token, BigInteger value, String address) {
        this.token = token;
        this.value = value;
        this.address = address;
    }

    public Hash160 getToken() {
        return this.token;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransactionSendToken)) {
            return false;
        }
        TransactionSendToken that = (TransactionSendToken)o;
        return Objects.equals(this.getToken(), that.getToken()) && Objects.equals(this.getValue(), that.getValue()) && Objects.equals(this.getAddress(), that.getAddress());
    }

    public int hashCode() {
        return Objects.hash(this.getToken(), this.getValue(), this.getAddress());
    }

    public String toString() {
        return "TransactionSendToken{token='" + this.token + '\'' + ", value='" + this.value + '\'' + ", address='" + this.address + '\'' + '}';
    }
}

