/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.stackitem;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.neow3j.protocol.core.stackitem.StackItem;
import io.neow3j.types.StackItemType;
import io.neow3j.utils.BigIntegers;
import io.neow3j.utils.Numeric;
import java.math.BigInteger;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IntegerStackItem
extends StackItem {
    @JsonProperty(value="value")
    private BigInteger value;

    public IntegerStackItem() {
        super(StackItemType.INTEGER);
    }

    public IntegerStackItem(BigInteger value) {
        super(StackItemType.INTEGER);
        this.value = value;
    }

    @Override
    public BigInteger getValue() {
        return this.value;
    }

    @Override
    protected String valueToString() {
        return this.value.toString();
    }

    @Override
    public boolean getBoolean() {
        this.nullCheck();
        if (this.value.equals(BigInteger.ONE)) {
            return true;
        }
        if (this.value.equals(BigInteger.ZERO)) {
            return false;
        }
        return super.getBoolean();
    }

    @Override
    public BigInteger getInteger() {
        this.nullCheck();
        return this.value;
    }

    @Override
    public String getString() {
        this.nullCheck();
        return this.value.toString();
    }

    @Override
    public String getHexString() {
        this.nullCheck();
        return Numeric.toHexStringNoPrefix(this.getByteArray());
    }

    @Override
    public byte[] getByteArray() {
        this.nullCheck();
        return BigIntegers.toLittleEndianByteArray(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntegerStackItem)) {
            return false;
        }
        IntegerStackItem other = (IntegerStackItem)o;
        return this.getType() == other.getType() && this.getValue().equals(other.getValue());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.getValue()});
    }
}

