/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.stackitem;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.neow3j.protocol.core.stackitem.StackItem;
import io.neow3j.types.StackItemType;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class ListLikeStackItem
extends StackItem {
    @JsonProperty(value="value")
    private List<StackItem> value;

    protected ListLikeStackItem(StackItemType type) {
        super(type);
    }

    protected ListLikeStackItem(List<StackItem> value, StackItemType type) {
        super(type);
        this.value = value;
    }

    @Override
    public List<StackItem> getValue() {
        return this.value;
    }

    @Override
    protected String valueToString() {
        return this.value.stream().map(StackItem::toString).reduce("", (a, b) -> a + ", " + b).substring(2);
    }

    @Override
    public List<StackItem> getList() {
        this.nullCheck();
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListLikeStackItem)) {
            return false;
        }
        ListLikeStackItem other = (ListLikeStackItem)o;
        return this.getType() == other.getType() && Objects.equals(this.getValue(), other.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

