/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.stackitem;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.neow3j.protocol.core.stackitem.AnyStackItem;
import io.neow3j.protocol.core.stackitem.ArrayStackItem;
import io.neow3j.protocol.core.stackitem.BooleanStackItem;
import io.neow3j.protocol.core.stackitem.BufferStackItem;
import io.neow3j.protocol.core.stackitem.ByteStringStackItem;
import io.neow3j.protocol.core.stackitem.IntegerStackItem;
import io.neow3j.protocol.core.stackitem.InteropInterfaceStackItem;
import io.neow3j.protocol.core.stackitem.MapStackItem;
import io.neow3j.protocol.core.stackitem.PointerStackItem;
import io.neow3j.protocol.core.stackitem.StructStackItem;
import io.neow3j.protocol.exceptions.StackItemCastException;
import io.neow3j.types.StackItemType;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", include=JsonTypeInfo.As.EXISTING_PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AnyStackItem.class, name="Any"), @JsonSubTypes.Type(value=PointerStackItem.class, name="Pointer"), @JsonSubTypes.Type(value=BooleanStackItem.class, name="Boolean"), @JsonSubTypes.Type(value=IntegerStackItem.class, name="Integer"), @JsonSubTypes.Type(value=ByteStringStackItem.class, name="ByteString"), @JsonSubTypes.Type(value=BufferStackItem.class, name="Buffer"), @JsonSubTypes.Type(value=ArrayStackItem.class, name="Array"), @JsonSubTypes.Type(value=StructStackItem.class, name="Struct"), @JsonSubTypes.Type(value=MapStackItem.class, name="Map"), @JsonSubTypes.Type(value=InteropInterfaceStackItem.class, name="InteropInterface")})
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class StackItem {
    protected static final int MAX_VALUE_STRING_LENGTH = 80;
    @JsonProperty(value="type")
    protected StackItemType type;

    public StackItem() {
    }

    public abstract Object getValue();

    public StackItem(StackItemType type) {
        this.type = type;
    }

    public StackItemType getType() {
        return this.type;
    }

    protected abstract String valueToString();

    public String toString() {
        String valueString = this.getValue() == null ? "null" : this.valueToString();
        if (valueString.length() > 80) {
            valueString = valueString.substring(0, 80) + "...";
        }
        return this.type.getValue() + "{value='" + valueString + "'}";
    }

    @JsonIgnore
    public boolean getBoolean() {
        throw new StackItemCastException(String.format("Cannot cast stack item %s to a boolean.", this.toString()));
    }

    @JsonIgnore
    public BigInteger getInteger() {
        throw new StackItemCastException(String.format("Cannot cast stack item %s to an integer.", this.toString()));
    }

    @JsonIgnore
    public String getAddress() {
        throw new StackItemCastException(String.format("Cannot cast stack item %s to an address.", this.toString()));
    }

    @JsonIgnore
    public String getString() {
        throw new StackItemCastException(String.format("Cannot cast stack item %s to a string.", this.toString()));
    }

    @JsonIgnore
    public String getHexString() {
        throw new StackItemCastException(String.format("Cannot cast stack item %s to a hex string.", this.toString()));
    }

    @JsonIgnore
    public byte[] getByteArray() {
        throw new StackItemCastException(String.format("Cannot cast stack item %s to a byte array.", this.toString()));
    }

    @JsonIgnore
    public List<StackItem> getList() {
        throw new StackItemCastException(String.format("Cannot cast stack item %s to a list.", this.toString()));
    }

    @JsonIgnore
    public Map<StackItem, StackItem> getMap() {
        throw new StackItemCastException(String.format("Cannot cast stack item %s to a map.", this.toString()));
    }

    @JsonIgnore
    public BigInteger getPointer() {
        throw new StackItemCastException(String.format("Cannot cast stack item %s to a neo-vm pointer.", this.toString()));
    }

    @JsonIgnore
    public List<StackItem> getIterator() {
        throw new StackItemCastException(String.format("Cannot cast stack item %s to a neo-vm interoperability interface.", this.toString()));
    }

    protected void nullCheck() {
        if (this.getValue() == null) {
            throw new StackItemCastException("Cannot cast stack item because its value is null");
        }
    }
}

