/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.script;

import io.neow3j.crypto.Hash;
import io.neow3j.utils.ArrayUtils;
import io.neow3j.utils.Numeric;
import java.nio.charset.StandardCharsets;

public enum InteropService {
    SYSTEM_CONTRACT_CALL("System.Contract.Call", 32768L),
    SYSTEM_CONTRACT_CALLNATIVE("System.Contract.CallNative", 0L),
    SYSTEM_CONTRACT_GETCALLFLAGS("System.Contract.GetCallFlags", 1024L),
    SYSTEM_CONTRACT_CREATESTANDARDACCOUNT("System.Contract.CreateStandardAccount", 256L),
    SYSTEM_CONTRACT_CREATEMULTISIGACCOUNT("System.Contract.CreateMultisigAccount", 256L),
    SYSTEM_CONTRACT_NATIVEONPERSIST("System.Contract.NativeOnPersist", 0L),
    SYSTEM_CONTRACT_NATIVEPOSTPERSIST("System.Contract.NativePostPersist", 0L),
    SYSTEM_CRYPTO_CHECKSIG("System.Crypto.CheckSig", 32768L),
    SYSTEM_CRYPTO_CHECKMULTISIG("System.Crypto.CheckMultisig", 0L),
    SYSTEM_ITERATOR_NEXT("System.Iterator.Next", 32768L),
    SYSTEM_ITERATOR_VALUE("System.Iterator.Value", 16L),
    SYSTEM_RUNTIME_PLATFORM("System.Runtime.Platform", 8L),
    SYSTEM_RUNTIME_GETTRIGGER("System.Runtime.GetTrigger", 8L),
    SYSTEM_RUNTIME_GETTIME("System.Runtime.GetTime", 8L),
    SYSTEM_RUNTIME_GETSCRIPTCONTAINER("System.Runtime.GetScriptContainer", 8L),
    SYSTEM_RUNTIME_GETEXECUTINGSCRIPTHASH("System.Runtime.GetExecutingScriptHash", 16L),
    SYSTEM_RUNTIME_GETCALLINGSCRIPTHASH("System.Runtime.GetCallingScriptHash", 16L),
    SYSTEM_RUNTIME_GETENTRYSCRIPTHASH("System.Runtime.GetEntryScriptHash", 16L),
    SYSTEM_RUNTIME_CHECKWITNESS("System.Runtime.CheckWitness", 1024L),
    SYSTEM_RUNTIME_GETINVOCATIONCOUNTER("System.Runtime.GetInvocationCounter", 16L),
    SYSTEM_RUNTIME_LOG("System.Runtime.Log", 32768L),
    SYSTEM_RUNTIME_NOTIFY("System.Runtime.Notify", 32768L),
    SYSTEM_RUNTIME_GETNOTIFICATIONS("System.Runtime.GetNotifications", 256L),
    SYSTEM_RUNTIME_GASLEFT("System.Runtime.GasLeft", 16L),
    SYSTEM_RUNTIME_BURNGAS("System.Runtime.BurnGas", 16L),
    SYSTEM_RUNTIME_GETNETWORK("System.Runtime.GetNetwork", 8L),
    SYSTEM_RUNTIME_GETRANDOM("System.Runtime.GetRandom", 16L),
    SYSTEM_STORAGE_GETCONTEXT("System.Storage.GetContext", 16L),
    SYSTEM_STORAGE_GETREADONLYCONTEXT("System.Storage.GetReadOnlyContext", 16L),
    SYSTEM_STORAGE_ASREADONLY("System.Storage.AsReadOnly", 16L),
    SYSTEM_STORAGE_GET("System.Storage.Get", 32768L),
    SYSTEM_STORAGE_FIND("System.Storage.Find", 32768L),
    SYSTEM_STORAGE_PUT("System.Storage.Put", 32768L),
    SYSTEM_STORAGE_DELETE("System.Storage.Delete", 32768L),
    DUMMY("Dummy", 0L);

    private final String name;
    private final long price;

    private InteropService(String name, long price) {
        this.name = name;
        this.price = price;
    }

    public String getName() {
        return this.name;
    }

    public String getHash() {
        byte[] sha256 = Hash.sha256(this.getName().getBytes(StandardCharsets.US_ASCII));
        return Numeric.toHexStringNoPrefix(ArrayUtils.getFirstNBytes(sha256, 4));
    }

    public long getPrice() {
        if (this.price == 0L) {
            throw new UnsupportedOperationException("The price of the interop service " + this.getName() + " is not fixed.");
        }
        return this.price;
    }

    public String toString() {
        return this.getName();
    }
}

