/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.script;

import io.neow3j.crypto.ECKeyPair;
import io.neow3j.script.InteropService;
import io.neow3j.script.OpCode;
import io.neow3j.script.ScriptBuilder;
import io.neow3j.serialization.BinaryReader;
import io.neow3j.serialization.BinaryWriter;
import io.neow3j.serialization.IOUtils;
import io.neow3j.serialization.NeoSerializable;
import io.neow3j.serialization.exceptions.DeserializationException;
import io.neow3j.transaction.exceptions.ScriptFormatException;
import io.neow3j.types.Hash160;
import io.neow3j.utils.ArrayUtils;
import io.neow3j.utils.Numeric;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class VerificationScript
extends NeoSerializable {
    private byte[] script;

    public VerificationScript() {
        this.script = new byte[0];
    }

    public VerificationScript(byte[] script) {
        this.script = script;
    }

    public VerificationScript(ECKeyPair.ECPublicKey publicKey) {
        this.script = ScriptBuilder.buildVerificationScript(publicKey.getEncoded(true));
    }

    public VerificationScript(List<ECKeyPair.ECPublicKey> publicKeys, int signingThreshold) {
        if (signingThreshold < 1 || signingThreshold > publicKeys.size()) {
            throw new IllegalArgumentException("Signing threshold must be at least 1 and not higher than the number of public keys.");
        }
        if (publicKeys.size() > 1024) {
            throw new IllegalArgumentException("At max 1024 public keys can take part in a multi-sig account");
        }
        List<byte[]> encodedKeys = publicKeys.stream().map(key -> key.getEncoded(true)).collect(Collectors.toList());
        this.script = ScriptBuilder.buildVerificationScript(encodedKeys, signingThreshold);
    }

    public byte[] getScript() {
        return this.script;
    }

    @Override
    public byte[] toArray() {
        return super.toArray();
    }

    public Hash160 getScriptHash() {
        if (this.script.length == 0) {
            return null;
        }
        return Hash160.fromScript(this.script);
    }

    @Override
    public int getSize() {
        return IOUtils.getVarSize(this.script.length) + this.script.length;
    }

    public int getSigningThreshold() {
        if (this.isSingleSigScript()) {
            return 1;
        }
        if (this.isMultiSigScript()) {
            try {
                return new BinaryReader(this.script).readPushInteger();
            }
            catch (DeserializationException e) {
                throw new RuntimeException(e);
            }
        }
        throw new ScriptFormatException("The signing threshold cannot be determined because this script does not apply to the format of a signature verification script.");
    }

    public int getNrOfAccounts() {
        return this.getPublicKeys().size();
    }

    public boolean isSingleSigScript() {
        if (this.script.length != 40) {
            return false;
        }
        String interopService = Numeric.toHexStringNoPrefix(ArrayUtils.getLastNBytes(this.script, 4));
        return this.script[0] == OpCode.PUSHDATA1.getCode() && this.script[1] == 33 && this.script[35] == OpCode.SYSCALL.getCode() && interopService.equals(InteropService.SYSTEM_CRYPTO_CHECKSIG.getHash());
    }

    public boolean isMultiSigScript() {
        if (this.script.length < 42) {
            return false;
        }
        try {
            BinaryReader reader = new BinaryReader(this.script);
            int n = reader.readPushInteger();
            if (n < 1 || n > 1024) {
                return false;
            }
            int m = 0;
            while (reader.readByte() == OpCode.PUSHDATA1.getCode()) {
                if (this.script.length <= reader.getPosition() + 35) {
                    return false;
                }
                if (reader.readByte() != 33) {
                    return false;
                }
                reader.readEncodedECPoint();
                ++m;
                reader.mark(0);
            }
            if (n > m || m > 1024) {
                return false;
            }
            reader.reset();
            int alsoM = reader.readPushInteger();
            if (m != alsoM) {
                return false;
            }
            if (reader.readByte() != OpCode.SYSCALL.getCode()) {
                return false;
            }
            byte[] interopServiceCode = new byte[4];
            reader.read(interopServiceCode, 0, 4);
            if (!Numeric.toHexStringNoPrefix(interopServiceCode).equals(InteropService.SYSTEM_CRYPTO_CHECKMULTISIG.getHash())) {
                return false;
            }
        }
        catch (DeserializationException | IOException e) {
            return false;
        }
        return true;
    }

    public List<ECKeyPair.ECPublicKey> getPublicKeys() {
        BinaryReader reader = new BinaryReader(this.script);
        ArrayList<ECKeyPair.ECPublicKey> keys = new ArrayList<ECKeyPair.ECPublicKey>();
        try {
            if (this.isSingleSigScript()) {
                reader.readByte();
                reader.readByte();
                keys.add(new ECKeyPair.ECPublicKey(reader.readECPoint()));
                return keys;
            }
            if (this.isMultiSigScript()) {
                reader.readPushInteger();
                while (reader.readByte() == OpCode.PUSHDATA1.getCode()) {
                    reader.readByte();
                    keys.add(new ECKeyPair.ECPublicKey(reader.readECPoint()));
                }
                return keys;
            }
        }
        catch (DeserializationException | IOException e) {
            throw new RuntimeException(e);
        }
        throw new ScriptFormatException("The verification script is in an incorrect format. No public keys can be read from it.");
    }

    @Override
    public void deserialize(BinaryReader reader) throws DeserializationException {
        try {
            this.script = reader.readVarBytes();
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        writer.writeVarBytes(this.script);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VerificationScript)) {
            return false;
        }
        VerificationScript that = (VerificationScript)o;
        return Arrays.equals(this.getScript(), that.getScript());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getScript()});
    }

    public String toString() {
        return "VerificationScript{script=" + Numeric.toHexStringNoPrefix(this.script) + '}';
    }
}

