/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.serialization;

import io.neow3j.constants.NeoConstants;
import io.neow3j.script.OpCode;
import io.neow3j.serialization.NeoSerializable;
import io.neow3j.serialization.exceptions.DeserializationException;
import io.neow3j.utils.BigIntegers;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.math.ec.ECPoint;

public class BinaryReader
implements AutoCloseable {
    private DataInputStream reader;
    private byte[] array = new byte[8];
    private ByteBuffer buffer = ByteBuffer.wrap(this.array).order(ByteOrder.LITTLE_ENDIAN);
    private int position = 0;
    private int mark = -1;

    public BinaryReader(InputStream stream) {
        this.reader = new DataInputStream(stream);
    }

    public BinaryReader(byte[] input) {
        this(new ByteArrayInputStream(input, 0, input.length));
    }

    public int getPosition() {
        return this.position;
    }

    public int getMark() {
        return this.mark;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public void mark(int readlimit) {
        this.reader.mark(readlimit);
        this.mark = this.getPosition();
    }

    public void reset() throws IOException {
        this.reader.reset();
        this.position = this.getMark();
    }

    public void read(byte[] buffer) throws IOException {
        this.reader.readFully(buffer);
        this.position += buffer.length;
    }

    public void read(byte[] buffer, int index, int length) throws IOException {
        this.reader.readFully(buffer, index, length);
        this.position += length;
    }

    public boolean readBoolean() throws IOException {
        boolean result = this.reader.readBoolean();
        ++this.position;
        return result;
    }

    public int readUnsignedByte() throws IOException {
        int result = this.reader.readUnsignedByte();
        ++this.position;
        return result;
    }

    public byte readByteKeepPosition() throws IOException {
        byte result = this.reader.readByte();
        return result;
    }

    public byte readByte() throws IOException {
        byte result = this.reader.readByte();
        ++this.position;
        return result;
    }

    public byte[] readBytes(int count) throws IOException {
        byte[] buffer = new byte[count];
        this.reader.readFully(buffer);
        this.position += buffer.length;
        return buffer;
    }

    public int readUInt16() throws IOException {
        this.reader.readFully(this.array, 0, 2);
        this.position += 2;
        return Short.toUnsignedInt(this.buffer.getShort(0));
    }

    public short readInt16() throws IOException {
        this.reader.readFully(this.array, 0, 2);
        this.position += 2;
        return this.buffer.getShort(0);
    }

    public long readUInt32() throws IOException {
        this.reader.readFully(this.array, 0, 4);
        this.position += 4;
        return Integer.toUnsignedLong(this.buffer.getInt(0));
    }

    public int readInt32() throws IOException {
        this.reader.readFully(this.array, 0, 4);
        this.position += 4;
        return this.buffer.getInt(0);
    }

    public long readInt64() throws IOException {
        this.reader.readFully(this.array, 0, 8);
        this.position += 8;
        return this.buffer.getLong(0);
    }

    public byte[] readEncodedECPoint() throws DeserializationException {
        byte[] ecPoint = new byte[33];
        try {
            byte encoded = this.reader.readByte();
            ++this.position;
            if (encoded == 2 || encoded == 3) {
                ecPoint[0] = encoded;
                this.reader.readFully(ecPoint, 1, 32);
                this.position += 32;
                return ecPoint;
            }
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
        throw new DeserializationException("Failed parsing encoded EC point.");
    }

    public ECPoint readECPoint() throws IOException {
        byte[] encoded;
        byte fb = this.reader.readByte();
        ++this.position;
        switch (fb) {
            case 0: {
                encoded = new byte[1];
                break;
            }
            case 2: 
            case 3: {
                encoded = new byte[33];
                encoded[0] = fb;
                this.reader.readFully(encoded, 1, 32);
                this.position += 32;
                break;
            }
            case 4: {
                encoded = new byte[65];
                encoded[0] = fb;
                this.reader.readFully(encoded, 1, 64);
                this.position += 64;
                break;
            }
            default: {
                throw new IOException();
            }
        }
        return NeoConstants.secp256r1DomainParams().getCurve().decodePoint(encoded);
    }

    public <T extends NeoSerializable> T readSerializable(Class<T> t) throws DeserializationException {
        try {
            NeoSerializable obj = (NeoSerializable)t.newInstance();
            obj.deserialize(this);
            return (T)obj;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DeserializationException(e);
        }
    }

    public <T extends NeoSerializable> List<T> readSerializableListVarBytes(Class<T> t) throws DeserializationException {
        try {
            int length = (int)this.readVarInt(0x10000000L);
            int bytesRead = 0;
            int initialOffset = this.getPosition();
            ArrayList<NeoSerializable> list = new ArrayList<NeoSerializable>();
            while (bytesRead < length) {
                NeoSerializable objInstance = (NeoSerializable)t.newInstance();
                list.add(objInstance);
                objInstance.deserialize(this);
                int currentOffset = this.getPosition();
                bytesRead = currentOffset - initialOffset;
            }
            return list;
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            throw new DeserializationException(e);
        }
    }

    public <T extends NeoSerializable> List<T> readSerializableList(Class<T> t) throws DeserializationException {
        try {
            int length = (int)this.readVarInt(0x10000000L);
            ArrayList<NeoSerializable> list = new ArrayList<NeoSerializable>(length);
            for (int i = 0; i < length; ++i) {
                NeoSerializable objInstance = (NeoSerializable)t.newInstance();
                list.add(objInstance);
                objInstance.deserialize(this);
            }
            return list;
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            throw new DeserializationException(e);
        }
    }

    public byte[] readVarBytes() throws IOException {
        return this.readVarBytes(0x1000000);
    }

    public String readVarString() throws IOException {
        return new String(this.readVarBytes(), StandardCharsets.UTF_8);
    }

    public byte[] readPushData() throws DeserializationException {
        try {
            byte singleByte = this.readByte();
            int size = 0;
            if (singleByte == OpCode.PUSHDATA1.getCode()) {
                size = this.readUnsignedByte();
            } else if (singleByte == OpCode.PUSHDATA2.getCode()) {
                size = this.readInt16();
            } else if (singleByte == OpCode.PUSHDATA4.getCode()) {
                size = this.readInt32();
            } else {
                throw new DeserializationException("Stream did not contain a PUSHDATA OpCode at the current position.");
            }
            if (size == 1) {
                return new byte[]{this.readByte()};
            }
            return this.readBytes(size);
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
    }

    public byte[] readVarBytes(int max) throws IOException {
        return this.readBytes((int)this.readVarInt(max));
    }

    public long readVarInt() throws IOException {
        return this.readVarInt(Long.MAX_VALUE);
    }

    public long readVarInt(long max) throws IOException {
        long fb = Byte.toUnsignedLong(this.readByte());
        long value = fb == 253L ? Short.toUnsignedLong(this.readInt16()) : (fb == 254L ? Integer.toUnsignedLong(this.readInt32()) : (fb == 255L ? this.readInt64() : fb));
        if (Long.compareUnsigned(value, max) > 0) {
            throw new IOException();
        }
        return value;
    }

    public String readPushString() throws DeserializationException {
        return new String(this.readPushData(), StandardCharsets.UTF_8);
    }

    public int readPushInteger() throws DeserializationException {
        return this.readPushBigInteger().intValue();
    }

    public BigInteger readPushBigInteger() throws DeserializationException {
        try {
            byte opCode = this.readByte();
            if (opCode >= OpCode.PUSHM1.getCode() && opCode <= OpCode.PUSH16.getCode()) {
                return BigInteger.valueOf(opCode - OpCode.PUSH0.getCode());
            }
            if (opCode == OpCode.PUSHINT8.getCode()) {
                return BigIntegers.fromLittleEndianByteArray(new byte[]{this.readByte()});
            }
            if (opCode == OpCode.PUSHINT16.getCode()) {
                return BigIntegers.fromLittleEndianByteArray(this.readBytes(2));
            }
            if (opCode == OpCode.PUSHINT32.getCode()) {
                return BigIntegers.fromLittleEndianByteArray(this.readBytes(4));
            }
            if (opCode == OpCode.PUSHINT64.getCode()) {
                return BigIntegers.fromLittleEndianByteArray(this.readBytes(8));
            }
            if (opCode == OpCode.PUSHINT128.getCode()) {
                return BigIntegers.fromLittleEndianByteArray(this.readBytes(16));
            }
            if (opCode == OpCode.PUSHINT256.getCode()) {
                return BigIntegers.fromLittleEndianByteArray(this.readBytes(32));
            }
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
        throw new DeserializationException("Couldn't parse PUSHINT OpCode");
    }

    public int available() throws IOException {
        return this.reader.available();
    }
}

