/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.transaction;

import io.neow3j.transaction.Signer;
import io.neow3j.transaction.WitnessScope;
import io.neow3j.types.Hash160;
import io.neow3j.wallet.Account;

public class AccountSigner
extends Signer {
    private Account account;

    private AccountSigner(Hash160 signerHash, WitnessScope scope) {
        super(signerHash, scope);
        this.account = Account.fromAddress(signerHash.toAddress());
    }

    private AccountSigner(Account account, WitnessScope scope) {
        super(account.getScriptHash(), scope);
        this.account = account;
    }

    public Account getAccount() {
        return this.account;
    }

    public static AccountSigner none(Account account) {
        return new AccountSigner(account, WitnessScope.NONE);
    }

    public static AccountSigner none(Hash160 accountHash) {
        return new AccountSigner(accountHash, WitnessScope.NONE);
    }

    public static AccountSigner calledByEntry(Account account) {
        return new AccountSigner(account, WitnessScope.CALLED_BY_ENTRY);
    }

    public static AccountSigner calledByEntry(Hash160 accountHash) {
        return new AccountSigner(accountHash, WitnessScope.CALLED_BY_ENTRY);
    }

    public static AccountSigner global(Account account) {
        return new AccountSigner(account, WitnessScope.GLOBAL);
    }

    public static AccountSigner global(Hash160 accountHash) {
        return new AccountSigner(accountHash, WitnessScope.GLOBAL);
    }
}

