/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.transaction;

import io.neow3j.crypto.ECKeyPair;
import io.neow3j.serialization.BinaryReader;
import io.neow3j.serialization.BinaryWriter;
import io.neow3j.serialization.IOUtils;
import io.neow3j.serialization.NeoSerializable;
import io.neow3j.serialization.exceptions.DeserializationException;
import io.neow3j.transaction.WitnessScope;
import io.neow3j.transaction.exceptions.SignerConfigurationException;
import io.neow3j.types.Hash160;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Signer
extends NeoSerializable {
    private Hash160 signerHash;
    private List<WitnessScope> scopes;
    private List<Hash160> allowedContracts;
    private List<ECKeyPair.ECPublicKey> allowedGroups;

    public Signer() {
    }

    protected Signer(Hash160 signerHash, WitnessScope scope) {
        this.signerHash = signerHash;
        this.scopes = new ArrayList<WitnessScope>();
        this.scopes.add(scope);
        this.allowedContracts = new ArrayList<Hash160>();
        this.allowedGroups = new ArrayList<ECKeyPair.ECPublicKey>();
    }

    public Signer setAllowedContracts(Hash160 ... allowedContracts) {
        if (allowedContracts.length == 0) {
            return this;
        }
        if (this.scopes.contains((Object)WitnessScope.GLOBAL)) {
            throw new SignerConfigurationException("Trying to set allowed contracts on a Signer with global scope.");
        }
        if (this.allowedContracts.size() + allowedContracts.length > 16) {
            throw new SignerConfigurationException("Tyring to set more than 16 allowed contracts on a signer.");
        }
        this.scopes.remove((Object)WitnessScope.NONE);
        this.scopes.add(WitnessScope.CUSTOM_CONTRACTS);
        this.allowedContracts.addAll(Arrays.asList(allowedContracts));
        return this;
    }

    public Signer setAllowedGroups(ECKeyPair.ECPublicKey ... allowedGroups) {
        if (allowedGroups.length == 0) {
            return this;
        }
        if (this.scopes.contains((Object)WitnessScope.GLOBAL)) {
            throw new SignerConfigurationException("Trying to set allowed contract groups on a Signer with global scope.");
        }
        if (this.allowedGroups.size() + allowedGroups.length > 16) {
            throw new SignerConfigurationException("Tyring to set more than 16 allowed contract groups on a signer.");
        }
        this.scopes.remove((Object)WitnessScope.NONE);
        this.scopes.add(WitnessScope.CUSTOM_GROUPS);
        this.allowedGroups.addAll(Arrays.asList(allowedGroups));
        return this;
    }

    public Hash160 getScriptHash() {
        return this.signerHash;
    }

    public List<WitnessScope> getScopes() {
        return this.scopes;
    }

    public List<Hash160> getAllowedContracts() {
        return this.allowedContracts;
    }

    public List<ECKeyPair.ECPublicKey> getAllowedGroups() {
        return this.allowedGroups;
    }

    @Override
    public void deserialize(BinaryReader reader) throws DeserializationException {
        try {
            this.signerHash = reader.readSerializable(Hash160.class);
            this.scopes = WitnessScope.extractCombinedScopes(reader.readByte());
            if (this.scopes.contains((Object)WitnessScope.CUSTOM_CONTRACTS)) {
                this.allowedContracts = reader.readSerializableList(Hash160.class);
                if (this.allowedContracts.size() > 16) {
                    throw new DeserializationException("A signer's scope can only contain 16 allowed contracts. The input data contained " + this.allowedContracts.size() + " contracts.");
                }
            }
            if (this.scopes.contains((Object)WitnessScope.CUSTOM_GROUPS)) {
                this.allowedGroups = reader.readSerializableList(ECKeyPair.ECPublicKey.class);
                if (this.allowedGroups.size() > 16) {
                    throw new DeserializationException("A signer's scope can only contain 16 allowed contract groups. The input data contained " + this.allowedGroups.size() + " groups.");
                }
            }
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        writer.writeSerializableFixed(this.signerHash);
        writer.writeByte(WitnessScope.combineScopes(this.scopes));
        if (this.scopes.contains((Object)WitnessScope.CUSTOM_CONTRACTS)) {
            writer.writeSerializableVariable(this.allowedContracts);
        }
        if (this.scopes.contains((Object)WitnessScope.CUSTOM_GROUPS)) {
            writer.writeSerializableVariable(this.allowedGroups);
        }
    }

    @Override
    public int getSize() {
        int size = 21;
        if (this.scopes.contains((Object)WitnessScope.CUSTOM_CONTRACTS)) {
            size += IOUtils.getVarSize(this.allowedContracts);
        }
        if (this.scopes.contains((Object)WitnessScope.CUSTOM_GROUPS)) {
            size += IOUtils.getVarSize(this.allowedGroups);
        }
        return size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signer that = (Signer)o;
        return Objects.equals(this.signerHash, that.signerHash) && Objects.equals(this.scopes, that.scopes) && Objects.equals(this.allowedContracts, that.allowedContracts) && Objects.equals(this.allowedGroups, that.allowedGroups);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.signerHash, this.scopes, this.allowedContracts, this.allowedGroups);
    }
}

