/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.transaction;

import io.neow3j.crypto.ECKeyPair;
import io.neow3j.protocol.Neow3j;
import io.neow3j.protocol.core.response.InvocationResult;
import io.neow3j.protocol.core.response.NeoInvokeScript;
import io.neow3j.script.VerificationScript;
import io.neow3j.transaction.AccountSigner;
import io.neow3j.transaction.ContractSigner;
import io.neow3j.transaction.HighPriorityAttribute;
import io.neow3j.transaction.Signer;
import io.neow3j.transaction.Transaction;
import io.neow3j.transaction.TransactionAttribute;
import io.neow3j.transaction.TransactionAttributeType;
import io.neow3j.transaction.Witness;
import io.neow3j.transaction.WitnessScope;
import io.neow3j.transaction.exceptions.TransactionConfigurationException;
import io.neow3j.types.ContractParameter;
import io.neow3j.types.Hash160;
import io.neow3j.utils.ArrayUtils;
import io.neow3j.utils.Numeric;
import io.neow3j.wallet.Account;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TransactionBuilder {
    private static final Hash160 GAS_TOKEN_HASH = new Hash160("d2a4cff31913016155e38e474a2c06d08be276cf");
    private static final String BALANCE_OF_FUNCTION = "balanceOf";
    private static final String DUMMY_PUB_KEY = "02ec143f00b88524caf36a0121c2de09eef0519ddbe1c710a00f0e2663201ee4c0";
    protected Neow3j neow3j;
    protected Transaction transaction;
    private byte version;
    private long nonce;
    private Long validUntilBlock;
    private List<Signer> signers;
    private long additionalNetworkFee;
    private List<TransactionAttribute> attributes;
    private byte[] script;
    private BiConsumer<BigInteger, BigInteger> consumer;
    private Supplier<? extends Throwable> supplier;

    public TransactionBuilder(Neow3j neow3j) {
        this.neow3j = neow3j;
        this.nonce = ThreadLocalRandom.current().nextLong((long)Math.pow(2.0, 32.0));
        this.version = 0;
        this.script = new byte[0];
        this.additionalNetworkFee = 0L;
        this.signers = new ArrayList<Signer>();
        this.attributes = new ArrayList<TransactionAttribute>();
    }

    public TransactionBuilder version(byte version) {
        this.version = version;
        return this;
    }

    public TransactionBuilder nonce(long nonce) {
        if (nonce < 0L || nonce >= (long)Math.pow(2.0, 32.0)) {
            throw new TransactionConfigurationException("The value of the transaction nonce must be in the interval [0, 2^32).");
        }
        this.nonce = nonce;
        return this;
    }

    public TransactionBuilder validUntilBlock(long blockNr) {
        if (blockNr < 0L || blockNr >= (long)Math.pow(2.0, 32.0)) {
            throw new TransactionConfigurationException("The block number up to which this transaction can be included cannot be less than zero or more than 2^32.");
        }
        this.validUntilBlock = blockNr;
        return this;
    }

    public TransactionBuilder firstSigner(Account sender) {
        return this.firstSigner(sender.getScriptHash());
    }

    public TransactionBuilder firstSigner(Hash160 sender) {
        if (this.signers.stream().map(Signer::getScopes).anyMatch(scopes -> scopes.contains((Object)WitnessScope.NONE))) {
            throw new IllegalStateException("This transaction contains a signer with fee-only witness scope that will cover the fees. Hence, the order of the signers does not affect the payment of the fees.");
        }
        Signer s = this.signers.stream().filter(signer -> signer.getScriptHash().equals(sender)).findFirst().orElseThrow(() -> new IllegalStateException("Could not find a signer with script hash " + sender.toString() + ". Make sure to add the signer before calling this method."));
        this.signers.remove(s);
        this.signers.add(0, s);
        return this;
    }

    public TransactionBuilder signers(Signer ... signers) {
        if (this.containsDuplicateSigners(signers)) {
            throw new TransactionConfigurationException("Cannot add multiple signers concerning the same account.");
        }
        this.checkAndThrowIfMaxAttributesExceeded(signers.length, this.attributes.size());
        this.signers = new ArrayList<Signer>(Arrays.asList(signers));
        return this;
    }

    private void checkAndThrowIfMaxAttributesExceeded(int totalSigners, int totalAttributes) {
        if (totalSigners + totalAttributes > 16) {
            throw new TransactionConfigurationException("A transaction cannot have more than 16 attributes (including signers).");
        }
    }

    public TransactionBuilder additionalNetworkFee(long fee) {
        this.additionalNetworkFee = fee;
        return this;
    }

    public TransactionBuilder script(byte[] script) {
        this.script = script;
        return this;
    }

    public TransactionBuilder extendScript(byte[] script) {
        this.script = ArrayUtils.concatenate(this.script, script);
        return this;
    }

    public TransactionBuilder attributes(TransactionAttribute ... attributes) {
        this.checkAndThrowIfMaxAttributesExceeded(this.signers.size(), this.attributes.size() + attributes.length);
        Arrays.stream(attributes).forEach(attr -> {
            if (attr.getType() == TransactionAttributeType.HIGH_PRIORITY) {
                this.safeAddHighPriorityAttribute((HighPriorityAttribute)attr);
            }
        });
        return this;
    }

    private void safeAddHighPriorityAttribute(HighPriorityAttribute attr) {
        if (!this.isHighPriority()) {
            this.attributes.add(attr);
        }
    }

    private boolean containsDuplicateSigners(Signer ... signers) {
        List signerList = Stream.of(signers).map(Signer::getScriptHash).collect(Collectors.toList());
        HashSet signerSet = new HashSet(signerList);
        return signerList.size() != signerSet.size();
    }

    public Transaction getUnsignedTransaction() throws Throwable {
        BigInteger senderGasBalance;
        if (this.script == null || this.script.length == 0) {
            throw new TransactionConfigurationException("Cannot build a transaction without a script.");
        }
        if (this.validUntilBlock == null) {
            this.validUntilBlock(this.fetchCurrentBlockCount() + this.neow3j.getMaxValidUntilBlockIncrement() - 1L);
        }
        if (this.signers.isEmpty()) {
            throw new IllegalStateException("Cannot create a transaction without signers. Atleast one signer with witness scope fee-only or higher is required.");
        }
        if (this.isHighPriority() && !this.isAllowedForHighPriority()) {
            throw new IllegalStateException("This transaction does not have a committee member as signer. Only committee members can send transactions with high priority.");
        }
        long systemFee = this.getSystemFeeForScript();
        long networkFee = this.calcNetworkFee() + this.additionalNetworkFee;
        BigInteger fees = BigInteger.valueOf(systemFee + networkFee);
        if (this.supplier != null && !this.canSenderCoverFees(fees)) {
            throw this.supplier.get();
        }
        if (this.consumer != null && fees.compareTo(senderGasBalance = this.getSenderGasBalance()) > 0) {
            this.consumer.accept(fees, senderGasBalance);
        }
        return new Transaction(this.neow3j, this.version, this.nonce, this.validUntilBlock, this.signers, systemFee, networkFee, this.attributes, this.script, new ArrayList<Witness>());
    }

    private boolean isHighPriority() {
        return this.attributes.stream().anyMatch(t -> t.getType() == TransactionAttributeType.HIGH_PRIORITY);
    }

    private boolean isAllowedForHighPriority() throws IOException {
        List<Hash160> committee = this.neow3j.getCommittee().send().getCommittee().stream().map(ECKeyPair.ECPublicKey::new).map(key -> key.getEncoded(true)).map(Hash160::fromPublicKey).collect(Collectors.toList());
        boolean signersContainCommitteeMember = this.signers.stream().map(Signer::getScriptHash).anyMatch(committee::contains);
        if (signersContainCommitteeMember) {
            return true;
        }
        return this.signersContainMultiSigWithCommitteeMember(committee);
    }

    private boolean signersContainMultiSigWithCommitteeMember(List<Hash160> committee) {
        Iterator iterator = this.signers.stream().iterator();
        while (iterator.hasNext()) {
            AccountSigner s;
            Account a;
            Signer signer = (Signer)iterator.next();
            if (!(signer instanceof AccountSigner) || !(a = (s = (AccountSigner)signer).getAccount()).isMultiSig()) continue;
            boolean containsCommitteeMemberInMultiSig = a.getVerificationScript().getPublicKeys().stream().map(key -> key.getEncoded(true)).map(Hash160::fromPublicKey).anyMatch(committee::contains);
            if (!containsCommitteeMemberInMultiSig) continue;
            return true;
        }
        return false;
    }

    private long fetchCurrentBlockCount() throws IOException {
        return this.neow3j.getBlockCount().send().getBlockCount().longValue();
    }

    private long getSystemFeeForScript() throws IOException {
        Signer[] signers = this.signers.toArray(new Signer[0]);
        String script = Numeric.toHexStringNoPrefix(this.script);
        NeoInvokeScript response = this.neow3j.invokeScript(script, signers).send();
        if (((InvocationResult)response.getResult()).hasStateFault()) {
            throw new TransactionConfigurationException("The vm exited due to the following exception: " + ((InvocationResult)response.getResult()).getException());
        }
        return new BigInteger(response.getInvocationResult().getGasConsumed()).longValue();
    }

    private long calcNetworkFee() throws IOException {
        Transaction tx = new Transaction(this.neow3j, this.version, this.nonce, this.validUntilBlock, this.signers, 0L, 0L, this.attributes, this.script, new ArrayList<Witness>());
        boolean hasAtLeastOneSigningAccount = false;
        for (Signer signer : this.signers) {
            if (signer instanceof ContractSigner) {
                ContractSigner contractSigner = (ContractSigner)signer;
                tx.addWitness(Witness.createContractWitness(contractSigner.getVerifyParameters()));
                continue;
            }
            Account a = ((AccountSigner)signer).getAccount();
            VerificationScript verificationScript = a.isMultiSig() ? this.createFakeMultiSigVerificationScript(a) : this.createFakeSingleSigVerificationScript();
            tx.addWitness(new Witness(new byte[0], verificationScript.getScript()));
            hasAtLeastOneSigningAccount = true;
        }
        if (!hasAtLeastOneSigningAccount) {
            throw new TransactionConfigurationException("A transaction requires at least one signing account (i.e. an AccountSigner). None was provided.");
        }
        String txHex = Numeric.toHexStringNoPrefix(tx.toArray());
        return this.neow3j.calculateNetworkFee(txHex).send().getNetworkFee().getNetworkFee().longValue();
    }

    private VerificationScript createFakeSingleSigVerificationScript() {
        return new VerificationScript(new ECKeyPair.ECPublicKey(DUMMY_PUB_KEY));
    }

    private VerificationScript createFakeMultiSigVerificationScript(Account a) {
        ArrayList<ECKeyPair.ECPublicKey> pubKeys = new ArrayList<ECKeyPair.ECPublicKey>();
        for (int i = 0; i < a.getNrOfParticipants(); ++i) {
            pubKeys.add(new ECKeyPair.ECPublicKey(DUMMY_PUB_KEY));
        }
        return new VerificationScript(pubKeys, a.getSigningThreshold());
    }

    public NeoInvokeScript callInvokeScript() throws IOException {
        if (this.signers == null || this.script.length == 0) {
            throw new TransactionConfigurationException("Cannot make an 'invokescript' call without the script being configured.");
        }
        Signer[] signers = this.signers.toArray(new Signer[0]);
        String script = Numeric.toHexStringNoPrefix(this.script);
        return this.neow3j.invokeScript(script, signers).send();
    }

    public Transaction sign() throws Throwable {
        this.transaction = this.getUnsignedTransaction();
        byte[] txBytes = this.transaction.getHashData();
        this.transaction.getSigners().forEach(signer -> {
            if (signer instanceof ContractSigner) {
                ContractSigner contractSigner = (ContractSigner)signer;
                this.transaction.addWitness(Witness.createContractWitness(contractSigner.getVerifyParameters()));
            } else {
                Account a = ((AccountSigner)signer).getAccount();
                if (a.isMultiSig()) {
                    throw new IllegalStateException("Transactions with multi-sig signers cannot be signed automatically.");
                }
                this.signWithAccount(txBytes, a);
            }
        });
        return this.transaction;
    }

    private void signWithAccount(byte[] txBytes, Account acc) {
        ECKeyPair keyPair = acc.getECKeyPair();
        if (keyPair == null) {
            throw new TransactionConfigurationException("Cannot create transaction signature because account " + acc.getAddress() + " does not hold a private key.");
        }
        this.transaction.addWitness(Witness.create(txBytes, keyPair));
    }

    public TransactionBuilder doIfSenderCannotCoverFees(BiConsumer<BigInteger, BigInteger> consumer) {
        if (this.supplier != null) {
            throw new IllegalStateException("Cannot handle a consumer for this case, since an exception will be thrown if the sender cannot cover the fees.");
        }
        this.consumer = consumer;
        return this;
    }

    public TransactionBuilder throwIfSenderCannotCoverFees(Supplier<? extends Throwable> exceptionSupplier) {
        if (this.consumer != null) {
            throw new IllegalStateException("Cannot handle a supplier for this case, since a consumer will be executed if the sender cannot cover the fees.");
        }
        this.supplier = exceptionSupplier;
        return this;
    }

    private BigInteger getSenderGasBalance() throws IOException {
        return this.neow3j.invokeFunction(GAS_TOKEN_HASH, BALANCE_OF_FUNCTION, Arrays.asList(ContractParameter.hash160(this.getSender())), new Signer[0]).send().getInvocationResult().getStack().get(0).getInteger();
    }

    private Hash160 getSender() {
        return this.signers.get(0).getScriptHash();
    }

    private boolean canSenderCoverFees(BigInteger fees) throws IOException {
        return fees.compareTo(this.getSenderGasBalance()) < 0;
    }

    public byte[] getScript() {
        return this.script;
    }

    public List<Signer> getSigners() {
        return this.signers;
    }
}

