/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.transaction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum WitnessScope {
    NONE("None", 0),
    CALLED_BY_ENTRY("CalledByEntry", 1),
    CUSTOM_CONTRACTS("CustomContracts", 16),
    CUSTOM_GROUPS("CustomGroups", 32),
    GLOBAL("Global", 128);

    private String jsonValue;
    private byte byteValue;

    private WitnessScope(String jsonValue, int byteValue) {
        this.jsonValue = jsonValue;
        this.byteValue = (byte)byteValue;
    }

    public static List<WitnessScope> extractCombinedScopes(byte combinedScopes) {
        if (combinedScopes == NONE.byteValue()) {
            return Arrays.asList(NONE);
        }
        ArrayList<WitnessScope> scopes = new ArrayList<WitnessScope>();
        if ((combinedScopes & GLOBAL.byteValue()) != 0) {
            scopes.add(GLOBAL);
        }
        if ((combinedScopes & CALLED_BY_ENTRY.byteValue()) != 0) {
            scopes.add(CALLED_BY_ENTRY);
        }
        if ((combinedScopes & CUSTOM_CONTRACTS.byteValue()) != 0) {
            scopes.add(CUSTOM_CONTRACTS);
        }
        if ((combinedScopes & CUSTOM_GROUPS.byteValue()) != 0) {
            scopes.add(CUSTOM_GROUPS);
        }
        return scopes;
    }

    public static byte combineScopes(List<WitnessScope> scopes) {
        byte combined = 0;
        for (WitnessScope s : scopes) {
            combined = (byte)(combined | s.byteValue());
        }
        return combined;
    }

    @JsonCreator
    public static WitnessScope fromJson(Object value) {
        if (value instanceof String) {
            return WitnessScope.fromJsonValue((String)value);
        }
        if (value instanceof Integer) {
            return WitnessScope.valueOf(((Integer)value).byteValue());
        }
        throw new IllegalArgumentException(String.format("%s value type not found.", WitnessScope.class.getName()));
    }

    public static WitnessScope valueOf(byte byteValue) {
        for (WitnessScope e : WitnessScope.values()) {
            if (e.byteValue != byteValue) continue;
            return e;
        }
        throw new IllegalArgumentException(String.format("%s value type not found.", WitnessScope.class.getName()));
    }

    public static WitnessScope fromJsonValue(String jsonValue) {
        for (WitnessScope e : WitnessScope.values()) {
            if (!e.jsonValue.equals(jsonValue)) continue;
            return e;
        }
        throw new IllegalArgumentException(String.format("%s value type not found.", WitnessScope.class.getName()));
    }

    public byte byteValue() {
        return this.byteValue;
    }

    @JsonValue
    public String jsonValue() {
        return this.jsonValue;
    }
}

