/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.types;

import com.fasterxml.jackson.annotation.JsonValue;
import io.neow3j.serialization.BinaryReader;
import io.neow3j.serialization.BinaryWriter;
import io.neow3j.serialization.NeoSerializable;
import io.neow3j.serialization.exceptions.DeserializationException;
import io.neow3j.utils.ArrayUtils;
import io.neow3j.utils.Numeric;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

public class Hash256
extends NeoSerializable
implements Comparable<Hash256> {
    private byte[] hash;
    public static final Hash256 ZERO = new Hash256("0000000000000000000000000000000000000000000000000000000000000000");

    public Hash256() {
        this.hash = new byte[32];
    }

    public Hash256(byte[] hash) {
        this.checkAndThrowHashLength(hash);
        this.hash = hash;
    }

    public Hash256(String hash) {
        if (!Numeric.isValidHexString(hash)) {
            throw new IllegalArgumentException("String argument is not hexadecimal.");
        }
        this.hash = Numeric.hexStringToByteArray(hash);
        this.checkAndThrowHashLength(this.hash);
    }

    @Override
    public void deserialize(BinaryReader reader) throws DeserializationException {
        try {
            this.hash = ArrayUtils.reverseArray(reader.readBytes(32));
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        writer.write(ArrayUtils.reverseArray(this.hash));
    }

    @Override
    public int getSize() {
        return 32;
    }

    @Override
    public byte[] toArray() {
        return this.hash;
    }

    public byte[] toLittleEndianArray() {
        return ArrayUtils.reverseArray(this.hash);
    }

    @JsonValue
    public String toString() {
        return Numeric.toHexStringNoPrefix(this.hash);
    }

    private void checkAndThrowHashLength(byte[] hash) {
        if (hash.length != 32) {
            throw new IllegalArgumentException("Hash must be 32 bytes long but was " + hash.length + " bytes.");
        }
    }

    @Override
    public int compareTo(Hash256 o) {
        return new BigInteger(1, this.hash).compareTo(new BigInteger(1, o.toArray()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hash256 that = (Hash256)o;
        return Arrays.equals(this.hash, that.hash);
    }

    public int hashCode() {
        return Arrays.hashCode(this.hash);
    }
}

