/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.utils;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Async {
    private static final ExecutorService DEFAULT_EXECUTOR = Executors.newCachedThreadPool();

    public static <T> CompletableFuture<T> run(Callable<T> callable, ExecutorService executor) {
        ExecutorService executorService = Optional.ofNullable(executor).orElse(DEFAULT_EXECUTOR);
        CompletableFuture result = new CompletableFuture();
        CompletableFuture.runAsync(() -> {
            try {
                result.complete(callable.call());
            }
            catch (Throwable e) {
                result.completeExceptionally(e);
            }
        }, executorService);
        return result;
    }

    public static <T> CompletableFuture<T> run(Callable<T> callable) {
        return Async.run(callable, DEFAULT_EXECUTOR);
    }

    public static ExecutorService getDefaultExecutor() {
        return DEFAULT_EXECUTOR;
    }

    private static int getCpuCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static ScheduledExecutorService defaultExecutorService() {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(Async.getCpuCount());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> Async.shutdown(scheduledExecutorService)));
        return scheduledExecutorService;
    }

    private static void shutdown(ExecutorService executorService) {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                executorService.shutdownNow();
                if (!executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    System.err.println("Thread pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> Async.shutdown(DEFAULT_EXECUTOR)));
    }
}

