/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.utils;

import io.neow3j.protocol.Neow3j;
import io.neow3j.protocol.core.response.NeoBlockCount;
import io.neow3j.protocol.core.response.NeoGetContractState;
import io.neow3j.protocol.core.response.NeoGetTransactionHeight;
import io.neow3j.protocol.core.response.NeoGetWalletBalance;
import io.neow3j.types.Hash160;
import io.neow3j.types.Hash256;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class Await {
    private static final int MAX_WAIT_TIME = 60;

    public static void waitUntilBalancesIsGreaterThanZero(Hash160 scriptHash, Hash160 token, Neow3j neow3j) {
        Await.waitUntil(Await.callableGetBalance(scriptHash, token, neow3j), Matchers.greaterThan((Comparable)Long.valueOf(0L)));
    }

    public static void waitUntilBlockCountIsGreaterThan(Neow3j neow3j, BigInteger blockCount) {
        Await.waitUntil(Await.callableGetBlockCount(neow3j), Matchers.greaterThan((Comparable)blockCount));
    }

    public static void waitUntilBlockCountIsGreaterThanZero(Neow3j neow3j) {
        Await.waitUntilBlockCountIsGreaterThan(neow3j, BigInteger.ZERO);
    }

    public static void waitUntilContractIsDeployed(Hash160 contract, Neow3j neow3j) {
        Await.waitUntil(Await.callableGetContractState(contract, neow3j), Matchers.is((Object)true));
    }

    public static void waitUntilTransactionIsExecuted(Hash256 txHash, Neow3j neow3j) {
        Await.waitUntil(Await.callableGetTxHash(txHash, neow3j), Matchers.notNullValue());
    }

    public static void waitUntilOpenWalletHasBalanceGreaterThanOrEqualTo(String amount, Hash160 token, Neow3j neow3j) {
        Await.waitUntil(Await.callableGetBalance(token, neow3j), Matchers.greaterThanOrEqualTo((Comparable)new BigDecimal(amount)));
    }

    public static <T> void waitUntil(Callable<T> callable, Matcher<? super T> matcher) {
        Await.waitUntil(callable, matcher, 60, TimeUnit.SECONDS);
    }

    public static <T> void waitUntil(Callable<T> callable, Matcher<? super T> matcher, int maxWaitTime, TimeUnit unit) {
        Awaitility.await().timeout((long)maxWaitTime, unit).until(callable, matcher);
    }

    private static Callable<Boolean> callableGetContractState(Hash160 contractHash160, Neow3j neow3j) {
        return () -> {
            try {
                NeoGetContractState response = neow3j.getContractState(contractHash160).send();
                if (response.hasError()) {
                    return false;
                }
                return response.getContractState().getHash().equals(contractHash160);
            }
            catch (IOException e) {
                return false;
            }
        };
    }

    private static Callable<BigInteger> callableGetBlockCount(Neow3j neow3j) {
        return () -> {
            try {
                NeoBlockCount getBlockCount = neow3j.getBlockCount().send();
                return getBlockCount.getBlockCount();
            }
            catch (IOException e) {
                return BigInteger.ZERO;
            }
        };
    }

    private static Callable<Long> callableGetBalance(Hash160 scriptHash, Hash160 tokenHash160, Neow3j neow3j) {
        return () -> {
            try {
                List balances = neow3j.getNep17Balances(scriptHash).send().getBalances().getBalances();
                return balances.stream().filter(b -> b.getAssetHash().equals(tokenHash160)).findFirst().map(b -> Long.valueOf(b.getAmount())).orElse(0L);
            }
            catch (IOException e) {
                return 0L;
            }
        };
    }

    private static Callable<Long> callableGetTxHash(Hash256 txHash, Neow3j neow3j) {
        return () -> {
            try {
                NeoGetTransactionHeight tx = neow3j.getTransactionHeight(txHash).send();
                if (tx.hasError()) {
                    return null;
                }
                return tx.getHeight().longValue();
            }
            catch (IOException e) {
                return null;
            }
        };
    }

    private static Callable<BigDecimal> callableGetBalance(Hash160 token, Neow3j neow3j) {
        return () -> {
            try {
                NeoGetWalletBalance response = neow3j.getWalletBalance(token).send();
                String balance = response.getWalletBalance().getBalance();
                return new BigDecimal(balance);
            }
            catch (IOException e) {
                return BigDecimal.ZERO;
            }
        };
    }
}

