/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.crypto;

import io.neow3j.crypto.Base58;
import io.neow3j.crypto.ECKeyPair;
import io.neow3j.crypto.Hash;
import io.neow3j.crypto.ScryptParams;
import io.neow3j.crypto.exceptions.CipherException;
import io.neow3j.crypto.exceptions.NEP2InvalidFormat;
import io.neow3j.crypto.exceptions.NEP2InvalidPassphrase;
import io.neow3j.utils.ArrayUtils;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.generators.SCrypt;

public class NEP2 {
    public static final int DKLEN = 64;
    public static final int NEP2_PRIVATE_KEY_LENGTH = 39;
    public static final byte NEP2_PREFIX_1 = 1;
    public static final byte NEP2_PREFIX_2 = 66;
    public static final byte NEP2_FLAGBYTE = -32;
    public static final int N_STANDARD = 16384;
    public static final int P_STANDARD = 8;
    public static final int R_STANDARD = 8;
    public static final ScryptParams DEFAULT_SCRYPT_PARAMS = new ScryptParams(16384, 8, 8);

    public static ECKeyPair decrypt(String password, String nep2String) throws CipherException, NEP2InvalidFormat, NEP2InvalidPassphrase {
        return NEP2.decrypt(password, nep2String, new ScryptParams(16384, 8, 8));
    }

    public static ECKeyPair decrypt(String password, String nep2String, ScryptParams scryptParams) throws NEP2InvalidFormat, CipherException, NEP2InvalidPassphrase {
        byte[] nep2Data = Base58.base58CheckDecode((String)nep2String);
        if (nep2Data.length != 39 || nep2Data[0] != 1 || nep2Data[1] != 66 || nep2Data[2] != -32) {
            throw new NEP2InvalidFormat("Not valid NEP2 prefix.");
        }
        byte[] addressHash = new byte[4];
        System.arraycopy(nep2Data, 3, addressHash, 0, 4);
        byte[] derivedKey = NEP2.generateDerivedScryptKey(password.getBytes(StandardCharsets.UTF_8), addressHash, scryptParams, 64);
        byte[] derivedKeyHalf1 = ArrayUtils.getFirstNBytes((byte[])derivedKey, (int)32);
        byte[] derivedKeyHalf2 = ArrayUtils.getLastNBytes((byte[])derivedKey, (int)32);
        byte[] encrypted = new byte[32];
        System.arraycopy(nep2Data, 7, encrypted, 0, 32);
        byte[] decrypted = NEP2.performCipherOperation(2, encrypted, derivedKeyHalf2);
        byte[] plainPrivateKey = ArrayUtils.xor((byte[])decrypted, (byte[])derivedKeyHalf1);
        ECKeyPair ecKeyPair = ECKeyPair.create(plainPrivateKey);
        byte[] calculatedAddressHash = NEP2.getAddressHash(ecKeyPair);
        if (!Arrays.equals(calculatedAddressHash, addressHash)) {
            throw new NEP2InvalidPassphrase("Calculated address hash does not match the one in the provided encrypted address.");
        }
        return ecKeyPair;
    }

    public static String encrypt(String password, ECKeyPair ecKeyPair) throws CipherException {
        return NEP2.encrypt(password, ecKeyPair, 16384, 8, 8);
    }

    public static String encrypt(String password, ECKeyPair ecKeyPair, ScryptParams scryptParams) throws CipherException {
        return NEP2.encrypt(password, ecKeyPair, scryptParams.getN(), scryptParams.getP(), scryptParams.getR());
    }

    public static String encrypt(String password, ECKeyPair ecKeyPair, int n, int p, int r) throws CipherException {
        byte[] addressHash = NEP2.getAddressHash(ecKeyPair);
        byte[] derivedKey = NEP2.generateDerivedScryptKey(password.getBytes(StandardCharsets.UTF_8), addressHash, n, r, p, 64);
        byte[] derivedHalf1 = ArrayUtils.getFirstNBytes((byte[])derivedKey, (int)32);
        byte[] derivedHalf2 = ArrayUtils.getLastNBytes((byte[])derivedKey, (int)32);
        byte[] encryptedHalf1 = NEP2.performCipherOperation(1, NEP2.xorPrivateKeyAndDerivedHalf(ecKeyPair, derivedHalf1, 0, 16), derivedHalf2);
        byte[] encryptedHalf2 = NEP2.performCipherOperation(1, NEP2.xorPrivateKeyAndDerivedHalf(ecKeyPair, derivedHalf1, 16, 32), derivedHalf2);
        byte[] prefixes = new byte[]{1, 66, -32};
        byte[] concatenation = ArrayUtils.concatenate((byte[][])new byte[][]{prefixes, addressHash, encryptedHalf1, encryptedHalf2});
        return Base58.base58CheckEncode((byte[])concatenation);
    }

    private static byte[] xorPrivateKeyAndDerivedHalf(ECKeyPair ecKeyPair, byte[] derivedHalf, int from, int to) {
        return ArrayUtils.xor((byte[])Arrays.copyOfRange(ecKeyPair.getPrivateKey().getBytes(), from, to), (byte[])Arrays.copyOfRange(derivedHalf, from, to));
    }

    private static byte[] generateDerivedScryptKey(byte[] password, byte[] salt, int n, int r, int p, int dkLen) {
        return SCrypt.generate((byte[])password, (byte[])salt, (int)n, (int)r, (int)p, (int)dkLen);
    }

    private static byte[] generateDerivedScryptKey(byte[] password, byte[] salt, ScryptParams scryptParams, int dkLen) {
        return SCrypt.generate((byte[])password, (byte[])salt, (int)scryptParams.getN(), (int)scryptParams.getR(), (int)scryptParams.getP(), (int)dkLen);
    }

    public static byte[] performCipherOperation(int mode, byte[] data, byte[] encryptKey) throws CipherException {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding", "BC");
            SecretKeySpec secretKeySpec = new SecretKeySpec(encryptKey, "AES");
            cipher.init(mode, secretKeySpec);
            return cipher.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CipherException("Error performing cipher operation", e);
        }
    }

    public static byte[] getAddressHash(ECKeyPair ecKeyPair) {
        String address = ecKeyPair.getAddress();
        byte[] addressHashed = Hash.hash256((byte[])address.getBytes());
        return ArrayUtils.getFirstNBytes((byte[])addressHashed, (int)4);
    }
}

