/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.test;

import io.neow3j.test.TestBlockchain;
import java.nio.file.Path;
import java.nio.file.Paths;

public class NeoExpressLocal
implements TestBlockchain {
    private Runtime rt = Runtime.getRuntime();
    private int secondsPerBlock = 0;
    private String neoxpConfig = "default.neo-express";
    private Path neoxpConfigFileDirectory;
    private Process neoxpProc;

    @Override
    public NeoExpressLocal withSecondsPerBlock(int secondsPerBlock) {
        this.secondsPerBlock = secondsPerBlock;
        return this;
    }

    @Override
    public TestBlockchain withBatchFile(String batchFile) {
        return null;
    }

    @Override
    public TestBlockchain withCheckpoint(String checkpointFile) {
        return null;
    }

    @Override
    public TestBlockchain withConfigFile(String configFile) {
        return null;
    }

    @Override
    public String getNodeUrl() {
        return null;
    }

    @Override
    public String resume() throws Exception {
        return null;
    }

    @Override
    public String halt() throws Exception {
        return null;
    }

    @Override
    public String createAccount() throws Exception {
        return null;
    }

    @Override
    public String enableOracle() throws Exception {
        return null;
    }

    @Override
    public String fastForward(int n) throws Exception {
        return null;
    }

    @Override
    public String execCommand(String ... commandParts) throws Exception {
        return null;
    }

    @Override
    public void start() {
        try {
            Path p = Paths.get(this.getClass().getClassLoader().getResource(this.neoxpConfig).toURI());
            this.neoxpConfigFileDirectory = p.getParent();
            this.runStopCommand().waitFor();
            this.runResetCommand().waitFor();
            this.neoxpProc = this.runStartCommand();
            Runtime.getRuntime().addShutdownHook(new Thread(this.neoxpProc::destroy));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
        try {
            this.runStopCommand().waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.neoxpProc.destroy();
    }

    @Override
    public TestBlockchain.GenesisAccount getGenesisAccount() throws Exception {
        return null;
    }

    @Override
    public String getAccount(String address) throws Exception {
        return null;
    }

    private Process runResetCommand() {
        try {
            return this.getDefaultProcessBuilder().command("neoxp", "reset", "-f").start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Process runStopCommand() {
        try {
            return this.getDefaultProcessBuilder().command("neoxp", "stop").start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Process runStartCommand() {
        try {
            ProcessBuilder b = this.getDefaultProcessBuilder();
            if (this.secondsPerBlock != 0) {
                b.command("neoxp", "run", "-s " + this.secondsPerBlock);
            } else {
                b.command("neoxp", "run");
            }
            return b.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ProcessBuilder getDefaultProcessBuilder() {
        return new ProcessBuilder(new String[0]).directory(this.neoxpConfigFileDirectory.toFile()).inheritIO();
    }
}

