/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.test;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.neow3j.test.NeoExpressConfig;
import io.neow3j.test.TestBlockchain;
import io.neow3j.test.TestProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.stream.Stream;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class NeoExpressTestContainer
extends GenericContainer<NeoExpressTestContainer>
implements TestBlockchain {
    public static final String DEFAULT_NEOXP_CONFIG = "default.neo-express";
    public static final String CONTAINER_WORKDIR = "/neoxp/";
    private static final String NEOXP_RUN_SCRIPT = "/neoxp/neoxp-run.sh";
    public static final String NEOXP_CONFIG_DEST = "/neoxp/default.neo-express";
    private static final String BATCH_FILE_DEST = "/neoxp/setup.batch";
    private static final String CHECKPOINT_FILE_DEST = "/neoxp/setup.neoxp-checkpoint";
    static final int EXPOSED_JSONRPC_PORT = 40332;
    static final ObjectMapper objectMapper = new ObjectMapper();
    private int secondsPerBlock = 0;
    private String neoxpConfigFile;
    private int accountCtr = 0;

    public NeoExpressTestContainer(String ... resources) {
        super(DockerImageName.parse((String)TestProperties.neoExpressDockerImage()));
        this.withExposedPorts(new Integer[]{40332});
        this.waitingFor((WaitStrategy)Wait.forListeningPort());
        int i = 0;
        while (resources != null && i + 1 < resources.length) {
            String src = resources[i++];
            String dest = resources[i++];
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)src, (Integer)777), dest);
        }
    }

    @Override
    public void start() {
        if (this.neoxpConfigFile == null) {
            this.neoxpConfigFile = DEFAULT_NEOXP_CONFIG;
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.neoxpConfigFile, (Integer)777), NEOXP_CONFIG_DEST);
        }
        super.start();
    }

    @Override
    public NeoExpressTestContainer withSecondsPerBlock(int secondsPerBlock) {
        if (secondsPerBlock < 1) {
            throw new IllegalArgumentException("Seconds per block must be 1 or higher.");
        }
        this.withCommand("-s " + secondsPerBlock);
        this.secondsPerBlock = secondsPerBlock;
        return this;
    }

    @Override
    public NeoExpressTestContainer withBatchFile(String batchFile) {
        this.withCopyFileToContainer(MountableFile.forClasspathResource((String)batchFile), BATCH_FILE_DEST);
        return this;
    }

    @Override
    public NeoExpressTestContainer withCheckpoint(String checkpointFile) {
        this.withCopyFileToContainer(MountableFile.forClasspathResource((String)checkpointFile), CHECKPOINT_FILE_DEST);
        return this;
    }

    @Override
    public NeoExpressTestContainer withConfigFile(String configFile) {
        NeoExpressConfig config;
        this.neoxpConfigFile = configFile;
        InputStream s = NeoExpressTestContainer.class.getClassLoader().getResourceAsStream(configFile);
        try {
            config = (NeoExpressConfig)new ObjectMapper().readValue(s, NeoExpressConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Config file is not a valid neo-express configuration.", e);
        }
        if (config.getConsensusNodes().size() > 1) {
            throw new IllegalStateException("Can't handle multi-node neo-express setups.");
        }
        this.withClasspathResourceMapping(configFile, NEOXP_CONFIG_DEST, BindMode.READ_WRITE);
        return this;
    }

    public NeoExpressTestContainer withNefAndManifestFiles(String nefFile, String manifestFile) {
        this.withCopyFileToContainer(MountableFile.forClasspathResource((String)nefFile, (Integer)777), CONTAINER_WORKDIR + nefFile);
        this.withCopyFileToContainer(MountableFile.forClasspathResource((String)manifestFile, (Integer)777), CONTAINER_WORKDIR + manifestFile);
        return this;
    }

    @Override
    public String getNodeUrl() {
        return "http://" + this.getContainerIpAddress() + ":" + this.getMappedPort(40332);
    }

    @Override
    public String resume() throws Exception {
        String cmd = this.secondsPerBlock != 0 ? "/neoxp/neoxp-run.sh " + this.secondsPerBlock : NEOXP_RUN_SCRIPT;
        Container.ExecResult execResult = this.execInContainer(new String[]{cmd});
        if (execResult.getExitCode() != 0) {
            throw new Exception("Failed executing command in container. Error was: \n " + execResult.getStderr());
        }
        return execResult.getStdout();
    }

    @Override
    public String halt() throws Exception {
        Container.ExecResult execResult = this.execInContainer(new String[]{"neoxp", "stop"});
        if (execResult.getExitCode() != 0) {
            throw new Exception("Failed executing command in container. Error was: \n " + execResult.getStderr());
        }
        return execResult.getStdout();
    }

    @Override
    public String createAccount() throws Exception {
        Container.ExecResult execResult = this.execInContainer(new String[]{"neoxp", "wallet", "create", "acc" + this.accountCtr++});
        if (execResult.getExitCode() != 0) {
            throw new Exception("Failed executing command in container. Error was: \n " + execResult.getStderr());
        }
        return execResult.getStdout().replaceAll(" ", "").split("\n")[1];
    }

    @Override
    public String enableOracle() throws Exception {
        Container.ExecResult execResult = this.execInContainer(new String[]{"neoxp", "oracle", "enable", "genesis"});
        if (execResult.getExitCode() != 0) {
            throw new Exception("Failed executing command in container. Error was: \n " + execResult.getStderr());
        }
        return execResult.getStdout().split(" ")[3];
    }

    @Override
    public String fastForward(int n) throws Exception {
        Container.ExecResult execResult = this.execInContainer(new String[]{"neoxp", "fastfwd", Integer.toString(n)});
        if (execResult.getExitCode() != 0) {
            throw new Exception("Failed executing command in container. Error was: \n " + execResult.getStderr());
        }
        return execResult.getStdout();
    }

    @Override
    public String execCommand(String ... commandParts) throws Exception {
        Container.ExecResult execResult = this.execInContainer(commandParts);
        if (execResult.getExitCode() != 0) {
            throw new Exception("Failed executing command in container. Error was: \n " + execResult.getStderr());
        }
        return execResult.getStdout();
    }

    @Override
    public String getAccount(String address) throws IOException {
        InputStream s = this.getClass().getClassLoader().getResourceAsStream(this.neoxpConfigFile);
        NeoExpressConfig config = (NeoExpressConfig)objectMapper.readValue(s, NeoExpressConfig.class);
        Optional<NeoExpressConfig.Wallet.Account> acc = Stream.concat(config.getConsensusNodes().stream().flatMap(n -> n.getWallet().getAccounts().stream()), config.getWallets().stream().flatMap(w -> w.getAccounts().stream())).filter(a -> a.getScriptHash().equals(address)).findFirst();
        if (!acc.isPresent()) {
            throw new IllegalArgumentException("Account with address '" + address + "' not found.");
        }
        if (acc.get().getPrivateKey() == null) {
            throw new IllegalStateException("Private key for account with address '" + address + "' not available.");
        }
        return acc.get().getPrivateKey();
    }

    @Override
    public TestBlockchain.GenesisAccount getGenesisAccount() throws IOException {
        InputStream s = this.getClass().getClassLoader().getResourceAsStream(this.neoxpConfigFile);
        NeoExpressConfig config = (NeoExpressConfig)objectMapper.readValue(s, NeoExpressConfig.class);
        NeoExpressConfig.Wallet w = config.getConsensusNodes().get(0).getWallet();
        Optional<NeoExpressConfig.Wallet.Account> genesisAcc = w.getAccounts().stream().filter(a -> a.getContract().getScript().length() >= 84).findFirst();
        if (!genesisAcc.isPresent()) {
            throw new IllegalStateException("Couldn't find genesis account in Neo Express config.");
        }
        return new TestBlockchain.GenesisAccount(genesisAcc.get().getContract().getScript(), genesisAcc.get().getPrivateKey());
    }
}

