/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.test;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Properties;

public class TestProperties {
    private static TestProperties instance = null;
    private final Properties properties = new Properties();

    protected TestProperties() throws IOException, URISyntaxException {
        this.properties.load(this.getClass().getResourceAsStream("/test.properties"));
    }

    public static TestProperties getInstance() {
        if (instance == null) {
            try {
                instance = new TestProperties();
            }
            catch (IOException | URISyntaxException ioe) {
                ioe.printStackTrace();
            }
        }
        return instance;
    }

    public static String defaultAccountAddress() {
        return TestProperties.getValue("defaultAccountAddress");
    }

    public static String defaultAccountWIF() {
        return TestProperties.getValue("defaultAccountWIF");
    }

    public static String defaultAccountPublicKey() {
        return TestProperties.getValue("defaultAccountPublicKey");
    }

    public static String defaultAccountPrivateKey() {
        return TestProperties.getValue("defaultAccountPrivateKey");
    }

    public static String defaultAccountEncryptedPrivateKey() {
        return TestProperties.getValue("defaultAccountEncryptedPrivateKey");
    }

    public static String defaultAccountPassword() {
        return TestProperties.getValue("defaultAccountPassword");
    }

    public static String defaultAccountScriptHash() {
        return TestProperties.getValue("defaultAccountScriptHash");
    }

    public static String defaultAccountVerificationScript() {
        return TestProperties.getValue("defaultAccountVerificationScript");
    }

    public static String client1AccountWIF() {
        return TestProperties.getValue("client1AccountWIF");
    }

    public static String client2AccountWIF() {
        return TestProperties.getValue("client2AccountWIF");
    }

    public static String neo3PrivateNetContainerImg() {
        return TestProperties.getValue("neo3PrivateNetContainerImg");
    }

    public static String neoExpressDockerImage() {
        return TestProperties.getValue("neoExpressDockerImage");
    }

    public static String committeeAccountAddress() {
        return TestProperties.getValue("committeeAccountAddress");
    }

    public static String committeeAccountScriptHash() {
        return TestProperties.getValue("committeeAccountScriptHash");
    }

    public static String committeeAccountVerificationScript() {
        return TestProperties.getValue("committeeAccountVerificationScript");
    }

    public static String neoTokenHash() {
        return TestProperties.getValue("neoTokenHash");
    }

    public static String gasTokenHash() {
        return TestProperties.getValue("gasTokenHash");
    }

    public static String contractManagementHash() {
        return TestProperties.getValue("contractManagementHash");
    }

    public static String roleManagementHash() {
        return TestProperties.getValue("roleManagementHash");
    }

    public static String stdLibHash() {
        return TestProperties.getValue("stdLibHash");
    }

    public static String cryptoLibHash() {
        return TestProperties.getValue("cryptoLibHash");
    }

    public static String ledgerContractHash() {
        return TestProperties.getValue("ledgerContractHash");
    }

    public static String policyContractHash() {
        return TestProperties.getValue("policyContractHash");
    }

    public static String oracleContractHash() {
        return TestProperties.getValue("oracleContractHash");
    }

    public static String gasTokenName() {
        return TestProperties.getValue("gasTokenName");
    }

    public static String getValue(String key) {
        return TestProperties.getInstance().properties.getProperty(key);
    }
}

