/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.test;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NeoExpressConfig {
    @JsonProperty
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private List<Wallet> wallets = new ArrayList<Wallet>();
    @JsonProperty(value="consensus-nodes")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private List<ConsensusNode> consensusNodes = new ArrayList<ConsensusNode>();

    public NeoExpressConfig() {
    }

    public NeoExpressConfig(List<Wallet> wallets) {
        this.wallets = wallets;
    }

    public List<Wallet> getWallets() {
        return this.wallets;
    }

    public List<ConsensusNode> getConsensusNodes() {
        return this.consensusNodes;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Wallet {
        @JsonProperty
        private String name;
        @JsonProperty
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private List<Account> accounts = new ArrayList<Account>();

        public Wallet() {
        }

        public Wallet(String name, List<Account> accounts) {
            this.name = name;
            this.accounts = accounts;
        }

        public String getName() {
            return this.name;
        }

        public List<Account> getAccounts() {
            return this.accounts;
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class Account {
            @JsonProperty(value="private-key")
            private String privateKey;
            @JsonProperty(value="script-hash")
            private String scriptHash;
            @JsonProperty
            private String label;
            @JsonProperty(value="is-default")
            private boolean isDefault;
            @JsonPropertyOrder
            private Contract contract;

            public Account() {
            }

            public Account(String privateKey, String scriptHash, String label, boolean isDefault, Contract contract) {
                this.privateKey = privateKey;
                this.scriptHash = scriptHash;
                this.label = label;
                this.isDefault = isDefault;
                this.contract = contract;
            }

            public String getPrivateKey() {
                return this.privateKey;
            }

            public String getScriptHash() {
                return this.scriptHash;
            }

            public String getLabel() {
                return this.label;
            }

            public boolean isDefault() {
                return this.isDefault;
            }

            public Contract getContract() {
                return this.contract;
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class Contract {
                @JsonProperty
                private String script;
                @JsonProperty
                @JsonSetter(nulls=Nulls.AS_EMPTY)
                private List<String> parameters = new ArrayList<String>();

                public Contract() {
                }

                public Contract(String script, List<String> parameters) {
                    this.script = script;
                    this.parameters = parameters;
                }

                public String getScript() {
                    return this.script;
                }

                public List<String> getParameters() {
                    return this.parameters;
                }
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ConsensusNode {
        private Wallet wallet;

        public ConsensusNode() {
        }

        public ConsensusNode(Wallet wallet) {
            this.wallet = wallet;
        }

        public Wallet getWallet() {
            return this.wallet;
        }
    }
}

