/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.test;

import io.neow3j.test.TestProperties;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class NeoTestContainer
extends GenericContainer<NeoTestContainer> {
    public static final String CONFIG_BASE_DIR = "neo-cli-config/";
    public static final String CONFIG_FILE_SOURCE = "neo-cli-config/config.json";
    static final String CONFIG_FILE_DESTINATION = "/neo-cli/config.json";
    static final String WALLET_FILE_SOURCE = "neo-cli-config/wallet.json";
    static final String WALLET_FILE_DESTINATION = "/neo-cli/wallet.json";
    static final String RPCCONFIG_FILE_SOURCE = "neo-cli-config/rpcserver.config.json";
    static final String RPCCONFIG_FILE_DESTINATION = "/neo-cli/Plugins/RpcServer/config.json";
    static final String DBFTCONFIG_FILE_SOURCE = "neo-cli-config/dbft.config.json";
    static final String DBFTCONFIG_FILE_DESTINATION = "/neo-cli/Plugins/DBFTPlugin/config.json";
    static final String ORACLECONFIG_FILE_SOURCE = "neo-cli-config/oracle.config.json";
    static final String ORACLECONFIG_FILE_DESTINATION = "/neo-cli/Plugins/OracleService/config.json";
    static final String APPLOGSCONFIG_FILE_SOURCE = "neo-cli-config/applicationlogs.config.json";
    static final String APPLOGSCONFIG_FILE_DESTINATION = "/neo-cli/Plugins/ApplicationLogs/config.json";
    static final String TOKEN_TRACKER_FILE_SOURCE = "neo-cli-config/tokentracker.config.json";
    static final String RPCNEP17TRACKER_FILE_DESTINATION = "/neo-cli/Plugins/TokensTracker/config.json";
    static final String STATE_SERVICE_FILE_SOURCE = "neo-cli-config/stateservice.config.json";
    static final String STATE_SERVICE_FILE_DESTINATION = "/neo-cli/Plugins/StateService/config.json";
    static final int EXPOSED_JSONRPC_PORT = 40332;

    public NeoTestContainer() {
        this(CONFIG_FILE_SOURCE);
    }

    public NeoTestContainer(String configFileSource) {
        super(DockerImageName.parse((String)TestProperties.neo3PrivateNetContainerImg()));
        if (configFileSource != null) {
            this.withClasspathResourceMapping(configFileSource, CONFIG_FILE_DESTINATION, BindMode.READ_ONLY);
        } else {
            this.withClasspathResourceMapping(CONFIG_FILE_SOURCE, CONFIG_FILE_DESTINATION, BindMode.READ_ONLY);
        }
        this.withCopyFileToContainer(MountableFile.forClasspathResource((String)WALLET_FILE_SOURCE, (Integer)777), WALLET_FILE_DESTINATION);
        this.withClasspathResourceMapping(RPCCONFIG_FILE_SOURCE, RPCCONFIG_FILE_DESTINATION, BindMode.READ_ONLY);
        this.withClasspathResourceMapping(DBFTCONFIG_FILE_SOURCE, DBFTCONFIG_FILE_DESTINATION, BindMode.READ_ONLY);
        this.withClasspathResourceMapping(APPLOGSCONFIG_FILE_SOURCE, APPLOGSCONFIG_FILE_DESTINATION, BindMode.READ_ONLY);
        this.withClasspathResourceMapping(TOKEN_TRACKER_FILE_SOURCE, RPCNEP17TRACKER_FILE_DESTINATION, BindMode.READ_ONLY);
        this.withClasspathResourceMapping(STATE_SERVICE_FILE_SOURCE, STATE_SERVICE_FILE_DESTINATION, BindMode.READ_ONLY);
        this.withExposedPorts(new Integer[]{40332});
        this.waitingFor((WaitStrategy)Wait.forListeningPort());
        try {
            this.withClasspathResourceMapping(ORACLECONFIG_FILE_SOURCE, ORACLECONFIG_FILE_DESTINATION, BindMode.READ_ONLY);
        }
        catch (IllegalArgumentException e) {
            System.out.println("OracleService config file not found at neo-cli-config/oracle.config.json");
        }
    }

    public static String getResultFilePath(String testClassName, String methodName) {
        return "responses/" + testClassName + "/" + methodName + ".json";
    }

    public String getNodeUrl() {
        return "http://" + this.getHost() + ":" + this.getMappedPort(40332);
    }
}

