/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.test;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.ContainsPattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.RegexPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;

public class WireMockTestHelper {
    public static void setUpWireMockForCall(String call, String responseFile, String ... params) throws IOException {
        String responseBody = WireMockTestHelper.loadFile("/responses/" + responseFile);
        StringBuilder regexPattern = new StringBuilder().append(".*\"method\":\"").append(call).append("\".*").append(".*\"params\":.*");
        for (String param : params) {
            regexPattern.append(".*").append(param).append(".*");
        }
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/")).withRequestBody((ContentPattern)new RegexPattern(regexPattern.toString())).willReturn(WireMock.aResponse().withStatus(200).withBody(responseBody)));
    }

    public static void setUpWireMockForGetBlockCount(long blockCount) throws IOException {
        String responseBody = WireMockTestHelper.loadFile("/responses/getblockcount_" + blockCount + ".json");
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/")).withRequestBody((ContentPattern)new ContainsPattern("\"method\":\"getblockcount\"")).willReturn(WireMock.aResponse().withStatus(200).withBody(responseBody)));
    }

    public static void setUpWireMockForInvokeFunction(String contractFunction, String responseFile) throws IOException {
        String responseBody = WireMockTestHelper.loadFile("/responses/" + responseFile);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/")).withRequestBody((ContentPattern)new RegexPattern(".*\"method\":\"invokefunction\".*\"params\":.*\"" + contractFunction + "\".*")).willReturn(WireMock.aResponse().withStatus(200).withBody(responseBody)));
    }

    public static void setUpWireMockForBalanceOf(String accountScriptHash, String responseFile) throws IOException {
        String responseBody = WireMockTestHelper.loadFile("/responses/" + responseFile);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/")).withRequestBody((ContentPattern)new RegexPattern(".*\"method\":\"invokefunction\".*\"params\":.*\"balanceOf\".*.*\"" + accountScriptHash + "\".*")).willReturn(WireMock.aResponse().withStatus(200).withBody(responseBody)));
    }

    public static String loadFile(String fileName) throws IOException {
        String absFileName = WireMockTestHelper.class.getResource(fileName).getFile();
        FileInputStream inStream = new FileInputStream(new File(absFileName));
        return Files.lines(new File(absFileName).toPath(), StandardCharsets.UTF_8).reduce((a, b) -> a + b).get();
    }
}

