/*
 * Decompiled with CFR 0.152.
 */
package io.nerdythings.okhttpprofiler;

import io.nerdythings.okhttpprofiler.transfer.DataTransfer;
import io.nerdythings.okhttpprofiler.transfer.LogDataTransfer;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import okhttp3.Interceptor;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/nerdythings/okhttpprofiler/OkHttpProfilerInterceptor;", "Lokhttp3/Interceptor;", "()V", "dataTransfer", "Lio/nerdythings/okhttpprofiler/transfer/DataTransfer;", "format", "Ljava/text/DateFormat;", "previousTime", "Ljava/util/concurrent/atomic/AtomicLong;", "generateId", "", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "okhttpprofiler_release"})
public final class OkHttpProfilerInterceptor
implements Interceptor {
    @NotNull
    private final DataTransfer dataTransfer = new LogDataTransfer();
    @NotNull
    private final DateFormat format = new SimpleDateFormat("ddhhmmssSSS", Locale.US);
    @NotNull
    private final AtomicLong previousTime = new AtomicLong();

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        String id = this.generateId();
        long startTime = System.currentTimeMillis();
        this.dataTransfer.sendRequest(id, chain.request());
        try {
            Response response = chain.proceed(chain.request());
            this.dataTransfer.sendResponse(id, response);
            this.dataTransfer.sendDuration(id, System.currentTimeMillis() - startTime);
            return response;
        }
        catch (Exception e) {
            this.dataTransfer.sendException(id, e);
            this.dataTransfer.sendDuration(id, System.currentTimeMillis() - startTime);
            throw e;
        }
    }

    private final synchronized String generateId() {
        String string = this.format.format(new Date());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        long currentTime = Long.parseLong(string);
        long previousTime = this.previousTime.get();
        if (currentTime <= previousTime) {
            currentTime = ++previousTime;
        }
        this.previousTime.set(currentTime);
        String string2 = Long.toString(currentTime, CharsKt.checkRadix((int)RangesKt.coerceIn((int)36, (int)2, (int)36)));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }
}

