/*
 * Decompiled with CFR 0.152.
 */
package io.nerdythings.okhttpprofiler.transfer;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import io.nerdythings.okhttpprofiler.transfer.DataTransfer;
import io.nerdythings.okhttpprofiler.transfer.MessageType;
import java.io.IOException;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0003J\"\u0010\f\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\bH\u0002J*\u0010\u000e\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001c\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u001cH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/nerdythings/okhttpprofiler/transfer/LogDataTransfer;", "Lio/nerdythings/okhttpprofiler/transfer/DataTransfer;", "()V", "mHandler", "Landroid/os/Handler;", "fastLog", "", "id", "", "type", "Lio/nerdythings/okhttpprofiler/transfer/MessageType;", "message", "largeLog", "content", "logWithHandler", "partsCount", "", "sendDuration", "duration", "", "sendException", "response", "Ljava/lang/Exception;", "Lkotlin/Exception;", "sendRequest", "request", "Lokhttp3/Request;", "sendResponse", "Lokhttp3/Response;", "Companion", "LogBodyHandler", "okhttpprofiler_release"})
public final class LogDataTransfer
implements DataTransfer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Handler mHandler;
    private static final int LOG_LENGTH = 4000;
    private static final int SLOW_DOWN_PARTS_AFTER = 20;
    private static final int BODY_BUFFER_SIZE = 0xA00000;
    @NotNull
    private static final String LOG_PREFIX = "OKPRFL";
    @NotNull
    private static final String DELIMITER = "_";
    private static final char HEADER_DELIMITER = ':';
    private static final char SPACE = ' ';
    @NotNull
    private static final String KEY_TAG = "TAG";
    @NotNull
    private static final String KEY_VALUE = "VALUE";
    @NotNull
    private static final String KEY_PARTS_COUNT = "PARTS_COUNT";
    @NotNull
    private static final String CONTENT_TYPE = "Content-Type";
    @NotNull
    private static final String CONTENT_LENGTH = "Content-Length";

    public LogDataTransfer() {
        HandlerThread handlerThread2 = new HandlerThread(this){
            final /* synthetic */ LogDataTransfer this$0;
            {
                this.this$0 = $receiver;
                super("OkHttpProfiler", 10);
            }

            protected void onLooperPrepared() {
                Looper looper = this.getLooper();
                Intrinsics.checkNotNullExpressionValue((Object)looper, (String)"getLooper(...)");
                LogDataTransfer.access$setMHandler$p(this.this$0, new LogBodyHandler(looper));
            }
        };
        handlerThread2.start();
    }

    @Override
    public void sendRequest(@NotNull String id, @NotNull Request request) throws IOException {
        block4: {
            RequestBody body;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.fastLog(id, MessageType.REQUEST_METHOD, request.method());
            this.fastLog(id, MessageType.REQUEST_URL, request.url().toString());
            this.fastLog(id, MessageType.REQUEST_TIME, String.valueOf(System.currentTimeMillis()));
            Buffer buffer = new Buffer();
            RequestBody requestBody = body = request.newBuilder().build().body();
            if (requestBody != null) {
                RequestBody it = requestBody;
                boolean bl = false;
                MediaType mediaType = body.contentType();
                if (mediaType != null) {
                    MediaType type = mediaType;
                    boolean bl2 = false;
                    this.fastLog(id, MessageType.REQUEST_HEADER, "Content-Type: " + type);
                }
                long contentLength = body.contentLength();
                if (contentLength != -1L) {
                    this.fastLog(id, MessageType.REQUEST_HEADER, "Content-Length: " + contentLength);
                }
            }
            Headers headers = request.headers();
            for (String name : headers.names()) {
                if (StringsKt.equals((String)CONTENT_TYPE, (String)name, (boolean)true) || StringsKt.equals((String)CONTENT_LENGTH, (String)name, (boolean)true)) continue;
                this.fastLog(id, MessageType.REQUEST_HEADER, name + ": " + headers.get(name));
            }
            RequestBody requestBody2 = body;
            if (requestBody2 == null) break block4;
            RequestBody it = requestBody2;
            boolean bl = false;
            body.writeTo((BufferedSink)buffer);
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
            this.largeLog(id, MessageType.REQUEST_BODY, buffer.readString(charset));
        }
    }

    @Override
    public void sendResponse(@NotNull String id, @NotNull Response response) throws IOException {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        ResponseBody responseBodyCopy = response.peekBody(0xA00000L);
        this.largeLog(id, MessageType.RESPONSE_BODY, responseBodyCopy.string());
        Headers headers = response.headers();
        this.logWithHandler(id, MessageType.RESPONSE_STATUS, String.valueOf(response.code()), 0);
        for (String name : headers.names()) {
            this.logWithHandler(id, MessageType.RESPONSE_HEADER, name + ":" + headers.get(name), 0);
        }
    }

    @Override
    public void sendException(@NotNull String id, @NotNull Exception response) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String string = response.getLocalizedMessage();
        if (string == null) {
            string = "Unknown exception";
        }
        this.logWithHandler(id, MessageType.RESPONSE_ERROR, string, 0);
    }

    @Override
    public void sendDuration(@NotNull String id, long duration) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.logWithHandler(id, MessageType.RESPONSE_TIME, String.valueOf(duration), 0);
        this.logWithHandler(id, MessageType.RESPONSE_END, "-->", 0);
    }

    @SuppressLint(value={"LogNotTimber"})
    private final void fastLog(String id, MessageType type, String message) {
        block0: {
            String string = message;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            String tag = "OKPRFL_" + id + DELIMITER + type.getText();
            Log.v((String)tag, (String)it);
        }
    }

    private final void logWithHandler(String id, MessageType type, String message, int partsCount) {
        Bundle bundle;
        if (this.mHandler == null) {
            return;
        }
        Handler handler = this.mHandler;
        if (handler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mHandler");
            handler = null;
        }
        Message message2 = handler.obtainMessage();
        Intrinsics.checkNotNullExpressionValue((Object)message2, (String)"obtainMessage(...)");
        Message handlerMessage = message2;
        String tag = "OKPRFL_" + id + DELIMITER + type.getText();
        Bundle $this$logWithHandler_u24lambda_u244 = bundle = new Bundle();
        boolean bl = false;
        $this$logWithHandler_u24lambda_u244.putString(KEY_TAG, tag);
        $this$logWithHandler_u24lambda_u244.putString(KEY_VALUE, message);
        $this$logWithHandler_u24lambda_u244.putInt(KEY_PARTS_COUNT, partsCount);
        Bundle bundle2 = bundle;
        handlerMessage.setData(bundle2);
        Handler handler2 = this.mHandler;
        if (handler2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mHandler");
            handler2 = null;
        }
        handler2.sendMessage(handlerMessage);
    }

    private final void largeLog(String id, MessageType type, String content) {
        int contentLength = content.length();
        if (contentLength > 4000) {
            int i = 0;
            int parts = contentLength / 4000;
            if (i <= parts) {
                while (true) {
                    int start;
                    int end;
                    if ((end = (start = i * 4000) + 4000) > contentLength) {
                        end = contentLength;
                    }
                    String string = content.substring(start, end);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    this.logWithHandler(id, type, string, parts);
                    if (i != parts) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else {
            this.logWithHandler(id, type, content, 0);
        }
    }

    public static final /* synthetic */ void access$setMHandler$p(LogDataTransfer $this, Handler handler) {
        $this.mHandler = handler;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/nerdythings/okhttpprofiler/transfer/LogDataTransfer$Companion;", "", "()V", "BODY_BUFFER_SIZE", "", "CONTENT_LENGTH", "", "CONTENT_TYPE", "DELIMITER", "HEADER_DELIMITER", "", "KEY_PARTS_COUNT", "KEY_TAG", "KEY_VALUE", "LOG_LENGTH", "LOG_PREFIX", "SLOW_DOWN_PARTS_AFTER", "SPACE", "okhttpprofiler_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lio/nerdythings/okhttpprofiler/transfer/LogDataTransfer$LogBodyHandler;", "Landroid/os/Handler;", "looper", "Landroid/os/Looper;", "(Landroid/os/Looper;)V", "handleMessage", "", "msg", "Landroid/os/Message;", "okhttpprofiler_release"})
    private static final class LogBodyHandler
    extends Handler {
        public LogBodyHandler(@NotNull Looper looper) {
            Intrinsics.checkNotNullParameter((Object)looper, (String)"looper");
            super(looper);
        }

        public void handleMessage(@NotNull Message msg) {
            block4: {
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                Bundle bundle = msg.getData();
                if (bundle == null) break block4;
                Bundle bundle2 = bundle;
                boolean bl = false;
                int partsCount = bundle2.getInt(LogDataTransfer.KEY_PARTS_COUNT, 0);
                if (partsCount > 20) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                String data = bundle2.getString(LogDataTransfer.KEY_VALUE);
                String key = bundle2.getString(LogDataTransfer.KEY_TAG);
                if (data != null && key != null) {
                    Log.v((String)key, (String)data);
                }
            }
        }
    }
}

