/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.aries;

import io.nessus.aries.AgentConfiguration;
import org.hyperledger.aries.AriesClient;
import org.hyperledger.aries.api.multitenancy.WalletRecord;

public class AriesClientFactory {
    public static AriesClient baseClient() {
        return AriesClientFactory.createClient(null, AgentConfiguration.defaultConfiguration());
    }

    public static AriesClient baseClient(AgentConfiguration config) {
        return AriesClientFactory.createClient(null, config);
    }

    public static AriesClient createClient(WalletRecord wallet) {
        return AriesClientFactory.createClient(wallet, AgentConfiguration.defaultConfiguration());
    }

    public static AriesClient createClient(WalletRecord wallet, AgentConfiguration config) {
        return AriesClient.builder().url(config.getAdminUrl()).apiKey(config.getApiKey()).bearerToken(wallet != null ? wallet.getToken() : null).build();
    }
}

