/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.aries.wallet;

import com.google.gson.Gson;
import io.nessus.aries.AgentConfiguration;
import io.nessus.aries.AriesClientFactory;
import io.nessus.aries.wallet.DefaultEventHandler;
import io.nessus.aries.wallet.WalletRegistry;
import java.io.IOException;
import java.util.List;
import org.hyperledger.acy_py.generated.model.DID;
import org.hyperledger.aries.AriesClient;
import org.hyperledger.aries.AriesWebSocketClient;
import org.hyperledger.aries.api.multitenancy.RemoveWalletRequest;
import org.hyperledger.aries.api.multitenancy.WalletRecord;
import org.hyperledger.aries.config.GsonConfig;
import org.hyperledger.aries.webhook.IEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NessusWallet
extends WalletRecord
implements AutoCloseable {
    static final Logger log = LoggerFactory.getLogger(WalletRecord.class);
    static final Gson gson = GsonConfig.defaultConfig();
    private transient WalletRegistry walletRegistry;
    private transient AriesWebSocketClient wsclient;
    private transient DID publicDid;

    public static NessusWallet build(WalletRecord wr) {
        String json = gson.toJson((Object)wr);
        NessusWallet wallet = (NessusWallet)gson.fromJson(json, NessusWallet.class);
        return wallet;
    }

    public NessusWallet withWalletRegistry(WalletRegistry walletRegistry) {
        this.walletRegistry = walletRegistry;
        return this;
    }

    public String getWalletName() {
        return this.getSettings().getWalletName();
    }

    public DID getPublicDid() {
        return this.publicDid;
    }

    public void setPublicDid(DID publicDid) {
        this.publicDid = publicDid;
    }

    public WalletRegistry getWalletRegistry() {
        return this.walletRegistry;
    }

    public AriesWebSocketClient getWebSocketClient() {
        return this.getWebSocketClient(AgentConfiguration.defaultConfiguration());
    }

    public AriesWebSocketClient getWebSocketClient(AgentConfiguration config) {
        if (this.wsclient == null) {
            this.wsclient = AriesWebSocketClient.builder().url(config.getWebSocketUrl()).apiKey(config.getApiKey()).bearerToken(this.getToken()).walletId(this.getWalletId()).handler((IEventHandler)new DefaultEventHandler(this, this.walletRegistry)).build();
        }
        return this.wsclient;
    }

    @Override
    public void close() throws IOException {
        this.closeWebSocket();
    }

    public synchronized void closeWebSocket() {
        if (this.wsclient != null) {
            this.wsclient.close();
            this.wsclient = null;
        }
    }

    public void closeAndRemove() throws IOException {
        log.info("Remove Wallet: {}", (Object)this.getWalletName());
        this.closeWebSocket();
        if (this.walletRegistry != null) {
            this.walletRegistry.removeWallet(this.getWalletId());
        }
        AriesClient baseClient = AriesClientFactory.baseClient();
        baseClient.multitenancyWalletRemove(this.getWalletId(), RemoveWalletRequest.builder().walletKey(this.getToken()).build());
        NessusWallet.sleepWell(500L);
        while (!((List)baseClient.multitenancyWallets(this.getWalletName()).get()).isEmpty()) {
            NessusWallet.sleepWell(500L);
        }
    }

    public static void sleepWell(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

