/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.aries.wallet;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.nessus.aries.HttpClientFactory;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.hyperledger.acy_py.generated.model.DID;
import org.hyperledger.aries.api.exception.AriesException;
import org.hyperledger.aries.api.ledger.IndyLedgerRoles;
import org.hyperledger.aries.config.GsonConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfRegistrationHandler {
    static final Logger log = LoggerFactory.getLogger(SelfRegistrationHandler.class);
    static final Gson gson = GsonConfig.defaultConfig();
    final String networkURL;

    public SelfRegistrationHandler(String url) {
        this.networkURL = url;
    }

    public boolean registerWithDID(String alias, String did, String verkey, IndyLedgerRoles role) throws IOException {
        JsonObject json = new JsonObject();
        json.addProperty("did", did);
        json.addProperty("verkey", verkey);
        if (alias != null) {
            json.addProperty("alias", alias);
        }
        if (role != null) {
            json.addProperty("role", role.toString());
        }
        log.info("Self register: {}", (Object)json);
        String res = this.call(this.buildPost(json));
        json = (JsonObject)gson.fromJson(res, JsonObject.class);
        log.info("Respose: {}", (Object)json);
        return true;
    }

    public DID registerWithSeed(String alias, String seed, IndyLedgerRoles role) throws IOException {
        JsonObject json = new JsonObject();
        json.addProperty("seed", seed);
        if (alias != null) {
            json.addProperty("alias", alias);
        }
        if (role != null) {
            json.addProperty("role", role.toString());
        }
        log.info("Self register: {}", (Object)json);
        String res = this.call(this.buildPost(json));
        DID did = (DID)gson.fromJson(res, DID.class);
        log.info("Respose: {}", (Object)did);
        return did;
    }

    private Request buildPost(Object body) {
        MediaType JSON_TYPE = MediaType.get((String)"application/json; charset=utf-8");
        RequestBody jsonBody = RequestBody.create((String)gson.toJson(body), (MediaType)JSON_TYPE);
        return new Request.Builder().url(this.networkURL).post(jsonBody).build();
    }

    private String call(Request req) throws IOException {
        String result = null;
        OkHttpClient httpClient = HttpClientFactory.createHttpClient();
        try (Response resp = httpClient.newCall(req).execute();){
            if (resp.isSuccessful() && resp.body() != null) {
                result = resp.body().string();
            } else if (!resp.isSuccessful()) {
                this.handleError(resp);
            }
        }
        return result;
    }

    private void handleError(Response resp) throws IOException {
        String msg = StringUtils.isNotEmpty((CharSequence)resp.message()) ? resp.message() : "";
        String body = resp.body() != null ? resp.body().string() : "";
        log.error("code={} message={}\nbody={}", new Object[]{resp.code(), msg, body});
        throw new AriesException(resp.code(), msg + "\n" + body);
    }
}

