/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.aries.wallet;

import com.google.gson.Gson;
import io.nessus.aries.AgentConfiguration;
import io.nessus.aries.AriesClientFactory;
import io.nessus.aries.util.AssertState;
import io.nessus.aries.wallet.NessusWallet;
import io.nessus.aries.wallet.SelfRegistrationHandler;
import io.nessus.aries.wallet.WalletRegistry;
import java.io.IOException;
import org.hyperledger.acy_py.generated.model.DID;
import org.hyperledger.acy_py.generated.model.DIDEndpoint;
import org.hyperledger.acy_py.generated.model.TxnOrRegisterLedgerNymResponse;
import org.hyperledger.aries.AriesClient;
import org.hyperledger.aries.api.ledger.IndyLedgerRoles;
import org.hyperledger.aries.api.ledger.RegisterNymFilter;
import org.hyperledger.aries.api.multitenancy.CreateWalletRequest;
import org.hyperledger.aries.api.multitenancy.WalletDispatchType;
import org.hyperledger.aries.api.multitenancy.WalletRecord;
import org.hyperledger.aries.api.multitenancy.WalletType;
import org.hyperledger.aries.api.wallet.WalletDIDCreate;
import org.hyperledger.aries.config.GsonConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalletBuilder {
    static final Logger log = LoggerFactory.getLogger(WalletBuilder.class);
    static final Gson gson = GsonConfig.defaultConfig();
    private String walletName;
    private String walletKey;
    private AgentConfiguration agentConfig = AgentConfiguration.defaultConfiguration();
    private WalletDispatchType dispatchType = WalletDispatchType.DEFAULT;
    private WalletType walletType = WalletType.INDY;
    private WalletRegistry walletRegistry;
    private WalletRecord trusteeWallet;
    private IndyLedgerRoles ledgerRole;
    private boolean selfRegister;

    public WalletBuilder(String walletName) {
        this.walletName = walletName;
    }

    public WalletBuilder agentConfig(AgentConfiguration agentConfig) {
        this.agentConfig = agentConfig;
        return this;
    }

    public WalletBuilder walletKey(String key) {
        this.walletKey = key;
        return this;
    }

    public WalletBuilder walletType(WalletType type) {
        this.walletType = type;
        return this;
    }

    public WalletBuilder dispatchType(WalletDispatchType dispatchType) {
        this.dispatchType = dispatchType;
        return this;
    }

    public WalletBuilder ledgerRole(IndyLedgerRoles role) {
        this.ledgerRole = role;
        return this;
    }

    public WalletBuilder selfRegisterNym(boolean flag) {
        this.selfRegister = flag;
        return this;
    }

    public WalletBuilder selfRegisterNym() {
        this.selfRegister = true;
        return this;
    }

    public WalletBuilder trusteeWallet(WalletRecord trusteeWallet) {
        this.trusteeWallet = trusteeWallet;
        return this;
    }

    public static boolean selfRegisterWithDid(String alias, String did, String vkey, IndyLedgerRoles role) throws IOException {
        String host = AgentConfiguration.getSystemEnv("INDY_WEBSERVER_HOSTNAME", "localhost");
        String port = AgentConfiguration.getSystemEnv("INDY_WEBSERVER_PORT", "9000");
        return new SelfRegistrationHandler(String.format("http://%s:%s/register", host, port)).registerWithDID(alias, did, vkey, role);
    }

    public WalletBuilder walletRegistry(WalletRegistry walletRegistry) {
        this.walletRegistry = walletRegistry;
        return this;
    }

    public NessusWallet build() throws IOException {
        CreateWalletRequest walletRequest = CreateWalletRequest.builder().walletKey((String)(this.walletKey != null ? this.walletKey : this.walletName + "Key")).walletDispatchType(this.dispatchType).walletName(this.walletName).walletType(this.walletType).build();
        log.info("CreateWalletRequest: {}", (Object)gson.toJson((Object)walletRequest));
        AriesClient baseClient = AriesClientFactory.baseClient(this.agentConfig);
        WalletRecord walletRecord = (WalletRecord)baseClient.multitenancyWalletCreate(walletRequest).get();
        NessusWallet nessusWallet = NessusWallet.build(walletRecord).withWalletRegistry(this.walletRegistry);
        String walletId = nessusWallet.getWalletId();
        log.info("{}: [{}] {}", new Object[]{this.walletName, walletId, nessusWallet});
        if (this.ledgerRole != null) {
            AssertState.isTrue(this.selfRegister || this.trusteeWallet != null, "LedgerRole " + this.ledgerRole + " requires selfRegister or trusteeWallet");
            AriesClient client = AriesClientFactory.createClient(nessusWallet, this.agentConfig);
            DID did = (DID)client.walletDidCreate(WalletDIDCreate.builder().build()).get();
            log.info("{}: {}", (Object)this.walletName, (Object)did);
            if (this.trusteeWallet != null) {
                AriesClient trustee = AriesClientFactory.createClient(this.trusteeWallet, this.agentConfig);
                String trusteeName = this.trusteeWallet.getSettings().getWalletName();
                TxnOrRegisterLedgerNymResponse nymResponse = (TxnOrRegisterLedgerNymResponse)trustee.ledgerRegisterNym(RegisterNymFilter.builder().did(did.getDid()).verkey(did.getVerkey()).role(this.ledgerRole).build()).get();
                log.info("{} for {}: {}", new Object[]{trusteeName, this.walletName, nymResponse});
            } else if (this.selfRegister) {
                WalletBuilder.selfRegisterWithDid(this.walletName, did.getDid(), did.getVerkey(), this.ledgerRole);
            }
            client.walletDidPublic(did.getDid());
            nessusWallet.setPublicDid(did);
            DIDEndpoint didEndpoint = (DIDEndpoint)client.walletGetDidEndpoint(did.getDid()).get();
            log.info("{}: {}", (Object)this.walletName, (Object)didEndpoint);
        }
        if (this.walletRegistry != null) {
            this.walletRegistry.putWallet(nessusWallet);
        }
        return nessusWallet;
    }
}

