/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.h2.testing;

import io.nessus.common.BasicConfig;
import io.nessus.common.testing.AbstractTest;
import io.nessus.h2.ConnectionFactory;
import java.sql.Connection;
import java.sql.SQLException;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractH2Test
extends AbstractTest<BasicConfig> {
    private ConnectionFactory conFactory;

    @Before
    public void before() throws Exception {
        this.createConnection();
    }

    @After
    public void after() throws Exception {
        Connection con = this.getConnection();
        if (con != null) {
            con.close();
        }
    }

    protected final ConnectionFactory createConnectionFactory() {
        return new ConnectionFactory(this.getConfig());
    }

    protected ConnectionFactory getConnectionFactory() {
        if (this.conFactory == null) {
            this.conFactory = this.createConnectionFactory();
        }
        return this.conFactory;
    }

    protected Connection getConnection() throws SQLException {
        ConnectionFactory factory = this.getConnectionFactory();
        return factory.getConnection();
    }

    protected Connection createConnection() throws SQLException {
        ConnectionFactory factory = this.getConnectionFactory();
        return factory.createConnection();
    }
}

