/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.testing;

import io.nessus.Blockchain;
import io.nessus.BlockchainFactory;
import io.nessus.Config;
import io.nessus.UTXO;
import io.nessus.Wallet;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wf.bitcoin.javabitcoindrpcclient.BitcoinRPCException;

public abstract class AbstractBlockchainTest {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    public static final String LABEL_BOB = "Bob";
    public static final String LABEL_MARRY = "Marry";
    public static final String LABEL_SINK = "Sink";

    protected static void importAddresses(Wallet wallet) throws IOException {
        List<String> labels = wallet.getLabels();
        if (!labels.isEmpty()) {
            return;
        }
        Config config = Config.parseConfig("/initial-import.json");
        for (Config.Address addr : config.getWallet().getAddresses()) {
            String privKey = addr.getPrivKey();
            String pubKey = addr.getPubKey();
            try {
                if (privKey != null && pubKey == null) {
                    wallet.addPrivateKey(privKey, addr.getLabels());
                    continue;
                }
                wallet.addAddress(pubKey, addr.getLabels());
            }
            catch (BitcoinRPCException ex) {
                String message = ex.getMessage();
                if (message.contains("walletpassphrase")) continue;
                throw ex;
            }
        }
    }

    protected BigDecimal estimateFee() {
        Blockchain blockchain = BlockchainFactory.getBlockchain();
        return blockchain.getNetwork().estimateFee();
    }

    protected BigDecimal addFee(BigDecimal amount) {
        return amount.add(this.estimateFee());
    }

    protected BigDecimal subtractFee(BigDecimal amount) {
        return amount.subtract(this.estimateFee());
    }

    protected BigDecimal getUTXOAmount(List<UTXO> utxos) {
        BigDecimal result = BigDecimal.ZERO;
        for (UTXO utxo : utxos) {
            result = result.add(utxo.getAmount());
        }
        return result;
    }

    protected void showAccountBalances() {
        Blockchain blockchain = BlockchainFactory.getBlockchain();
        Wallet wallet = blockchain.getWallet();
        for (String label : wallet.getLabels()) {
            if (label.startsWith("_")) continue;
            BigDecimal val = wallet.getBalance(label);
            this.LOG.info(String.format("%-5s: %13.8f", label, val));
        }
    }
}

