/*
 * Decompiled with CFR 0.152.
 */
package io.nessus;

import io.nessus.Blockchain;
import io.nessus.Network;
import io.nessus.RpcClientSupport;
import io.nessus.Wallet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wf.bitcoin.javabitcoindrpcclient.BitcoindRpcClient;

public abstract class AbstractNetwork
extends RpcClientSupport
implements Network {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    final Blockchain blockchain;

    protected AbstractNetwork(Blockchain blockchain, BitcoindRpcClient client) {
        super(client);
        this.blockchain = blockchain;
    }

    @Override
    public String getBlockHash(Integer height) {
        return this.client.getBlockHash(height.intValue());
    }

    @Override
    public Integer getBlockCount() {
        return this.client.getBlockCount();
    }

    @Override
    public BitcoindRpcClient.NetworkInfo getNetworkInfo() {
        return this.client.getNetworkInfo();
    }

    @Override
    public List<String> generate(int numBlocks) {
        return this.generate(numBlocks, null);
    }

    @Override
    public List<String> generate(int numBlocks, Wallet.Address address) {
        if (address != null) {
            return this.client.generateToAddress(numBlocks, address.getAddress());
        }
        return this.client.generate(numBlocks);
    }
}

