/*
 * Decompiled with CFR 0.152.
 */
package io.nessus;

import io.nessus.Blockchain;
import io.nessus.Config;
import io.nessus.Network;
import io.nessus.RpcClientSupport;
import io.nessus.Tx;
import io.nessus.TxInput;
import io.nessus.TxOutput;
import io.nessus.UTXO;
import io.nessus.Wallet;
import io.nessus.utils.AssertArgument;
import io.nessus.utils.AssertState;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wf.bitcoin.javabitcoindrpcclient.BitcoinJSONRPCClient;
import wf.bitcoin.javabitcoindrpcclient.BitcoinRPCException;
import wf.bitcoin.javabitcoindrpcclient.BitcoindRpcClient;
import wf.bitcoin.krotjson.HexCoder;

public abstract class AbstractWallet
extends RpcClientSupport
implements Wallet {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final Blockchain blockchain;

    protected AbstractWallet(Blockchain blockchain, BitcoindRpcClient client) {
        super(client);
        this.blockchain = blockchain;
    }

    protected Blockchain getBlockchain() {
        return this.blockchain;
    }

    @Override
    public void importAddresses(Config config) {
        for (Config.Address addr : config.getWallet().getAddresses()) {
            String privKey = addr.getPrivKey();
            String pubKey = addr.getPubKey();
            try {
                if (privKey != null && pubKey == null) {
                    this.addPrivateKey(privKey, addr.getLabels());
                    continue;
                }
                this.addAddress(pubKey, addr.getLabels());
            }
            catch (BitcoinRPCException ex) {
                String message = ex.getMessage();
                if (message.contains("walletpassphrase")) continue;
                throw ex;
            }
        }
    }

    @Override
    public Wallet.Address addPrivateKey(String privKey, List<String> labels) {
        AssertArgument.assertNotNull(privKey, "Null privKey");
        for (Wallet.Address addr : this.getAddressMapping().values()) {
            if (!privKey.equals(addr.getPrivKey())) continue;
            return addr;
        }
        this.client.importPrivKey(privKey, this.concatLabels(labels), true);
        Wallet.Address addr = null;
        for (Wallet.Address auxaddr : this.getAddressMapping().values()) {
            if (!privKey.equals(auxaddr.getPrivKey())) continue;
            addr = auxaddr;
            break;
        }
        AssertState.assertNotNull(addr, "Cannot get imported address from wallet");
        return addr;
    }

    @Override
    public Wallet.Address addAddress(String rawAddr, List<String> labels) {
        AssertArgument.assertNotNull(rawAddr, "Null privKey");
        for (Wallet.Address addr : this.getAddressMapping().values()) {
            if (!rawAddr.equals(addr.getAddress())) continue;
            return addr;
        }
        this.client.importAddress(rawAddr, this.concatLabels(labels), true);
        return this.createAdddressFromRaw(rawAddr, labels);
    }

    @Override
    public final Wallet.Address newAddress(String label) {
        return this.createNewAddress(Arrays.asList(label));
    }

    @Override
    public final Wallet.Address newChangeAddress(String label) {
        return this.createNewAddress(Arrays.asList(label, "(change)"));
    }

    @Override
    public List<String> getLabels() {
        HashSet labels = new HashSet();
        this.getAddressMapping().values().stream().forEach(a -> labels.addAll(a.getLabels()));
        return labels.stream().sorted().collect(Collectors.toList());
    }

    @Override
    public Wallet.Address getAddress(String label) {
        List<Wallet.Address> addrs = this.getAddresses(label);
        return (addrs = addrs.stream().filter(a -> !a.getLabels().contains("(change)")).collect(Collectors.toList())) != null && addrs.size() > 0 ? addrs.iterator().next() : null;
    }

    @Override
    public Wallet.Address findAddress(String rawAddr) {
        return this.getAddressMapping().values().stream().filter(a -> a.getAddress().equals(rawAddr)).findFirst().orElse(null);
    }

    @Override
    public List<Wallet.Address> getAddresses() {
        return this.getAddressMapping().values().stream().collect(Collectors.toList());
    }

    @Override
    public List<Wallet.Address> getAddresses(String label) {
        AssertArgument.assertNotNull(label, "Null label");
        List<Wallet.Address> filtered = this.getAddressMapping().values().stream().filter(a -> a.getLabels().contains(label)).collect(Collectors.toList());
        return filtered;
    }

    @Override
    public List<Wallet.Address> getChangeAddresses(String label) {
        AssertArgument.assertNotNull(label, "Null label");
        List<Wallet.Address> filtered = this.getAddresses(label).stream().filter(a -> a.getLabels().contains("(change)")).collect(Collectors.toList());
        return filtered;
    }

    @Override
    public Wallet.Address getChangeAddress(String label) {
        List<Wallet.Address> addrs = this.getChangeAddresses(label);
        if (addrs.isEmpty()) {
            addrs.add(this.newChangeAddress(label));
        }
        if (addrs.size() == 1) {
            return addrs.get(0);
        }
        int idx = new Random().nextInt(addrs.size());
        return addrs.get(idx);
    }

    @Override
    public BigDecimal getBalance(String label) {
        List<Wallet.Address> addrs = label != null ? this.getAddresses(label) : this.getAddresses();
        return AbstractWallet.getUTXOAmount(this.listUnspent(addrs));
    }

    @Override
    public BigDecimal getBalance(Wallet.Address addr) {
        return AbstractWallet.getUTXOAmount(this.listUnspent(Arrays.asList(addr)));
    }

    public static BigDecimal getUTXOAmount(List<UTXO> utxos) {
        BigDecimal result = BigDecimal.ZERO;
        for (UTXO utxo : utxos) {
            result = result.add(utxo.getAmount());
        }
        return result;
    }

    @Override
    public String sendToAddress(String toAddress, BigDecimal amount) {
        return this.client.sendToAddress(toAddress, amount);
    }

    @Override
    public String sendFromLabel(String label, String toAddress, BigDecimal amount) {
        BigDecimal estFee = this.estimateFee();
        BigDecimal dustAmount = this.blockchain.getNetwork().getDustThreshold();
        String txId = null;
        if (amount != ALL_FUNDS) {
            BigDecimal sendAmount = amount.add(estFee);
            List<UTXO> utxos = this.selectUnspent(label, sendAmount);
            BigDecimal utxosAmount = AbstractWallet.getUTXOAmount(utxos);
            AssertState.assertTrue(sendAmount.doubleValue() <= utxosAmount.doubleValue(), "Cannot find sufficient funds");
            String changeAddr = this.getChangeAddress(label).getAddress();
            BigDecimal changeAmount = utxosAmount.subtract(sendAmount);
            Tx.TxBuilder builder = new Tx.TxBuilder().unspentInputs(utxos).output(toAddress, amount);
            if (dustAmount.compareTo(changeAmount) < 0) {
                builder.output(changeAddr, changeAmount);
            }
            Tx tx = builder.build();
            txId = this.sendTx(tx);
        } else {
            List<UTXO> utxos = this.listUnspent(label);
            BigDecimal utxosAmount = AbstractWallet.getUTXOAmount(utxos);
            BigDecimal sendAmount = utxosAmount.subtract(estFee);
            if (dustAmount.compareTo(sendAmount) < 0) {
                Tx.TxBuilder builder = new Tx.TxBuilder().unspentInputs(utxos).output(toAddress, sendAmount);
                Tx tx = builder.build();
                txId = this.sendTx(tx);
            }
        }
        this.LOG.debug("txId: {}", txId);
        return txId;
    }

    @Override
    public String sendTx(Tx tx) {
        String rawTx = this.createRawTx(tx);
        String signedTx = this.signRawTx(rawTx, tx.inputs());
        return this.sendRawTransaction(signedTx);
    }

    public String createRawTx(Tx tx) {
        return this.client.createRawTransaction(this.adaptInputs(tx.inputs()), this.adaptOutputs(tx.outputs()));
    }

    public String signRawTx(String rawTx, List<TxInput> inputs) {
        ArrayList<String> privKeys = new ArrayList<String>();
        for (TxInput txin : inputs) {
            UTXO utxo = (UTXO)txin;
            Wallet.Address addr = this.findAddress(utxo.getAddress());
            String privKey = addr.getPrivKey();
            privKeys.add(privKey);
        }
        return this.client.signRawTransaction(rawTx, this.adaptInputs(inputs), privKeys);
    }

    public String sendRawTransaction(String signedTx) {
        return this.client.sendRawTransaction(signedTx);
    }

    @Override
    public List<UTXO> listUnspent(String label) {
        return this.listUnspent(this.getAddresses(label));
    }

    @Override
    public List<UTXO> listUnspent(List<Wallet.Address> addrs) {
        ArrayList<UTXO> result = new ArrayList<UTXO>();
        List<String> rawAddrs = this.getRawAddresses(addrs);
        for (BitcoindRpcClient.Unspent unspnt : this.client.listUnspent(0, Integer.MAX_VALUE, rawAddrs.toArray(new String[addrs.size()]))) {
            String txId = unspnt.txid();
            Integer vout = unspnt.vout();
            String addr = unspnt.address();
            String scriptPubKey = unspnt.scriptPubKey();
            BigDecimal amount = unspnt.amount();
            result.add(new UTXO(txId, vout, scriptPubKey, addr, amount));
        }
        return result;
    }

    @Override
    public List<UTXO> listLockUnspent(List<Wallet.Address> addrs) {
        ArrayList<UTXO> result = new ArrayList<UTXO>();
        List<String> rawAddrs = this.getRawAddresses(addrs);
        for (BitcoindRpcClient.LockedUnspent unspnt : this.client.listLockUnspent()) {
            TxOutput txout;
            String rawAddr;
            String txId = unspnt.txId();
            Integer vout = unspnt.vout();
            Tx tx = this.getLockedTransaction(txId);
            if (tx == null || !rawAddrs.contains(rawAddr = (txout = tx.outputs().get(vout)).getAddress())) continue;
            BigDecimal amount = txout.getAmount();
            result.add(new UTXO(txId, vout, null, rawAddr, amount));
        }
        return result;
    }

    protected Tx getLockedTransaction(String txId) {
        return this.getTransaction(txId);
    }

    @Override
    public boolean lockUnspent(UTXO utxo, boolean unlock) {
        return this.client.lockUnspent(unlock, utxo.getTxId(), utxo.getVout().intValue());
    }

    @Override
    public List<UTXO> selectUnspent(String label, BigDecimal amount) {
        List<Wallet.Address> addrs = this.getAddresses(label);
        return this.selectUnspent(addrs, amount);
    }

    @Override
    public List<UTXO> selectUnspent(List<Wallet.Address> addrs, BigDecimal amount) {
        BigDecimal total = BigDecimal.ZERO;
        ArrayList<UTXO> result = new ArrayList<UTXO>();
        for (UTXO utxo : this.listUnspent(addrs)) {
            result.add(utxo);
            total = total.add(utxo.getAmount());
            if (amount == ALL_FUNDS || amount.compareTo(total) > 0) continue;
            break;
        }
        AssertState.assertTrue(amount.compareTo(total) <= 0, "Insufficient funds: " + total);
        return result;
    }

    @Override
    public Tx getTransaction(String txId) {
        BitcoindRpcClient.Transaction tx = this.client.getTransaction(txId);
        Tx.TxBuilder builder = new Tx.TxBuilder();
        builder.txId(tx.txId());
        builder.blockHash(tx.blockHash());
        builder.blockTime(tx.blockTime());
        BitcoindRpcClient.RawTransaction rawTx = tx.raw();
        if (rawTx != null) {
            for (BitcoindRpcClient.RawTransaction.In in : rawTx.vIn()) {
                TxInput txIn = new TxInput(in.txid(), in.vout(), in.scriptPubKey());
                builder.input(txIn);
            }
            for (BitcoindRpcClient.RawTransaction.Out out : rawTx.vOut()) {
                BitcoindRpcClient.RawTransaction.Out.ScriptPubKey spk = out.scriptPubKey();
                List addrs = spk.addresses();
                String addr = null;
                if (addrs != null && addrs.size() > 0) {
                    if (addrs.size() > 1) {
                        this.LOG.warn("Multiple addresses not supported");
                    }
                    addr = (String)addrs.get(0);
                }
                byte[] data = null;
                String hex = spk.hex();
                String type = spk.type();
                byte op = HexCoder.decode((String)hex.substring(0, 2))[0];
                if (op == 106) {
                    data = HexCoder.decode((String)hex);
                }
                TxOutput txOut = new TxOutput(addr, out.value(), data);
                txOut.setType(type);
                builder.output(txOut);
            }
        }
        return builder.build();
    }

    public Wallet.Address updateAddress(Wallet.Address addr, List<String> labels) {
        String rawAddr = addr.getAddress();
        String combined = this.concatLabels(labels);
        ((BitcoinJSONRPCClient)this.client).query("setaccount", new Object[]{rawAddr, combined});
        return this.findAddress(rawAddr);
    }

    public void redeemChange(String label, Wallet.Address toAddr) {
        if (label == null || toAddr == null) {
            return;
        }
        List<Wallet.Address> addrs = this.getChangeAddresses(label);
        List<UTXO> utxos = this.listUnspent(addrs);
        if (!utxos.isEmpty()) {
            BigDecimal amount = AbstractWallet.getUTXOAmount(utxos);
            amount = amount.subtract(this.estimateFee());
            BigDecimal dustAmount = this.blockchain.getNetwork().getDustThreshold();
            if (dustAmount.compareTo(amount) < 0) {
                Tx tx = new Tx.TxBuilder().unspentInputs(utxos).output(toAddr.getAddress(), amount).build();
                this.sendTx(tx);
            }
        }
    }

    protected abstract Wallet.Address createAdddressFromRaw(String var1, List<String> var2);

    protected abstract Wallet.Address createNewAddress(List<String> var1);

    protected abstract boolean isP2PKH(String var1);

    protected String concatLabels(List<String> labels) {
        String result = labels.toString();
        return result.substring(1, result.length() - 1);
    }

    protected List<String> splitLabels(String labels) {
        return Arrays.asList(labels.split(",")).stream().map(t -> t.trim()).collect(Collectors.toList());
    }

    private Map<String, Wallet.Address> getAddressMapping() {
        LinkedHashMap<String, Wallet.Address> result = new LinkedHashMap<String, Wallet.Address>();
        for (String acc : this.client.listAccounts(0, true).keySet()) {
            for (String rawAddr : this.client.getAddressesByAccount(acc)) {
                if (!this.isP2PKH(rawAddr)) continue;
                result.put(rawAddr, this.createAdddressFromRaw(rawAddr, this.splitLabels(acc)));
            }
        }
        return result;
    }

    private BigDecimal estimateFee() {
        Network network = this.blockchain.getNetwork();
        return network.estimateFee();
    }

    private List<String> getRawAddresses(List<Wallet.Address> addrs) {
        return addrs.stream().map(a -> a.getAddress()).collect(Collectors.toList());
    }

    private List<BitcoindRpcClient.TxInput> adaptInputs(List<TxInput> inputs) {
        ArrayList<BitcoindRpcClient.TxInput> result = new ArrayList<BitcoindRpcClient.TxInput>();
        for (TxInput aux : inputs) {
            result.add((BitcoindRpcClient.TxInput)new BitcoindRpcClient.BasicTxInput(aux.getTxId(), aux.getVout(), aux.getScriptPubKey()));
        }
        return result;
    }

    private List<BitcoindRpcClient.TxOutput> adaptOutputs(List<TxOutput> outputs) {
        ArrayList<BitcoindRpcClient.TxOutput> result = new ArrayList<BitcoindRpcClient.TxOutput>();
        for (TxOutput aux : outputs) {
            result.add((BitcoindRpcClient.TxOutput)new BitcoindRpcClient.BasicTxOutput(aux.getAddress(), aux.getAmount(), aux.getData()));
        }
        return result;
    }
}

