/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.testing;

import io.nessus.AbstractWallet;
import io.nessus.Blockchain;
import io.nessus.BlockchainFactory;
import io.nessus.Config;
import io.nessus.Network;
import io.nessus.UTXO;
import io.nessus.Wallet;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.List;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBlockchainTest {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    public static final String LABEL_BOB = "Bob";
    public static final String LABEL_MARRY = "Marry";
    public static final String LABEL_SINK = "Sink";

    protected static void importAddresses(Wallet wallet, Class<?> configSource) throws IOException {
        URL configURL = configSource.getResource("/initial-import.json");
        if (configURL != null) {
            Config config = Config.parseConfig(configURL);
            wallet.importAddresses(config);
        }
    }

    protected static void generate(Blockchain blockchain) {
        Wallet wallet = blockchain.getWallet();
        Network network = blockchain.getNetwork();
        BigDecimal balance = wallet.getBalance("");
        if (balance.doubleValue() == 0.0) {
            List<String> blocks = network.generate(101, null);
            Assert.assertEquals((long)101L, (long)blocks.size());
        }
    }

    protected static BigDecimal getUTXOAmount(List<UTXO> utxos) {
        return AbstractWallet.getUTXOAmount(utxos);
    }

    protected BigDecimal estimateFee() {
        Blockchain blockchain = BlockchainFactory.getBlockchain();
        return blockchain.getNetwork().estimateFee();
    }

    protected BigDecimal addFee(BigDecimal amount) {
        return amount.add(this.estimateFee());
    }

    protected BigDecimal subtractFee(BigDecimal amount) {
        return amount.subtract(this.estimateFee());
    }

    protected void showAccountBalances() {
        Blockchain blockchain = BlockchainFactory.getBlockchain();
        Wallet wallet = blockchain.getWallet();
        for (String label : wallet.getLabels()) {
            if (label.equals("(change)")) continue;
            BigDecimal val = wallet.getBalance(label);
            this.LOG.info(String.format("%-5s: %13.8f", label, val));
        }
    }
}

