/*
 * Decompiled with CFR 0.152.
 */
package io.nessus;

import io.nessus.Blockchain;
import io.nessus.utils.AssertState;
import io.nessus.utils.SystemUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wf.bitcoin.javabitcoindrpcclient.BitcoindRpcClient;

public class BlockchainFactory {
    public static final String RPC_CLIENT_CLASS_NAME = "RPC_CLIENT_CLASS_NAME";
    public static final String BLOCKCHAIN_CLASS_NAME = "BLOCKCHAIN_CLASS_NAME";
    static final Logger LOG = LoggerFactory.getLogger(BlockchainFactory.class);
    private static Blockchain INSTANCE;

    public static <T extends Blockchain> T getBlockchain(Properties props, Class<T> bcClass) throws Exception {
        String rpcuser = props.getProperty("rpcuser");
        String rpcpass = props.getProperty("rpcpassword");
        String rpchost = props.getProperty("rpcconnect");
        String rpcport = props.getProperty("rpcport");
        return BlockchainFactory.getBlockchain(new URL(String.format("http://%s:%s@%s:%s", rpcuser, rpcpass, rpchost, rpcport)), bcClass);
    }

    public static <T extends Blockchain> T getBlockchain(URL rpcUrl, Class<T> bcClass) {
        if (INSTANCE == null) {
            try {
                LOG.info("{}: {}", (Object)bcClass.getSimpleName(), (Object)BlockchainFactory.getLogURL(rpcUrl));
                BitcoindRpcClient client = (BitcoindRpcClient)BlockchainFactory.loadRpcClientClass().getConstructor(URL.class).newInstance(rpcUrl);
                INSTANCE = (Blockchain)bcClass.getConstructor(BitcoindRpcClient.class).newInstance(client);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return (T)INSTANCE;
    }

    public static <T extends Blockchain> T getBlockchain(Class<T> bcClass) {
        AssertState.assertNotNull(INSTANCE, "Blockchain not initialized");
        return (T)INSTANCE;
    }

    public static Blockchain getBlockchain() {
        return BlockchainFactory.getBlockchain(Blockchain.class);
    }

    private static Class<?> loadRpcClientClass() throws ClassNotFoundException {
        String className = SystemUtils.getenv(RPC_CLIENT_CLASS_NAME, "wf.bitcoin.javabitcoindrpcclient.BitcoinJSONRPCClient");
        ClassLoader loader = BlockchainFactory.class.getClassLoader();
        return loader.loadClass(className);
    }

    private static URL getLogURL(URL rpcUrl) throws MalformedURLException {
        String protocol = rpcUrl.getProtocol();
        String host = rpcUrl.getHost();
        int port = rpcUrl.getPort();
        String path = rpcUrl.getPath();
        String userpass = "";
        if (rpcUrl.getUserInfo() != null) {
            userpass = rpcUrl.getUserInfo();
            userpass = userpass.substring(0, userpass.indexOf(58)) + ":*******@";
        }
        String query = rpcUrl.getQuery() != null ? rpcUrl.getQuery() : "";
        return new URL(String.format("%s://%s%s:%d%s%s", protocol, userpass, host, port, path, query));
    }
}

