/*
 * Decompiled with CFR 0.152.
 */
package io.nessus;

import io.nessus.Wallet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractAddress
implements Wallet.Address {
    private final String address;
    private final List<String> labels = new ArrayList<String>();
    private Boolean watchOnly;

    public AbstractAddress(String address) {
        this(address, Collections.emptyList());
    }

    public AbstractAddress(String address, List<String> labels) {
        this.address = address;
        this.labels.addAll(labels);
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public String getPrivKey() {
        return null;
    }

    @Override
    public Wallet.Address setLabels(List<String> labels) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWatchOnly() {
        if (this.watchOnly == null) {
            this.watchOnly = this.getPrivKey() == null;
        }
        return this.watchOnly;
    }

    @Override
    public List<String> getLabels() {
        return Collections.unmodifiableList(this.labels);
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Wallet.Address)) {
            return false;
        }
        Wallet.Address other = (Wallet.Address)obj;
        return this.address.equals(other.getAddress());
    }

    public String toString() {
        boolean wonly = this.isWatchOnly();
        return String.format("[addr=%s, wo=%b, labels=%s]", this.address, wonly, this.labels);
    }
}

