/*
 * Decompiled with CFR 0.152.
 */
package io.nessus;

import io.nessus.Blockchain;
import io.nessus.Config;
import io.nessus.Network;
import io.nessus.RpcClientSupport;
import io.nessus.Tx;
import io.nessus.TxInput;
import io.nessus.TxOutput;
import io.nessus.UTXO;
import io.nessus.Wallet;
import io.nessus.utils.AssertArgument;
import io.nessus.utils.AssertState;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wf.bitcoin.javabitcoindrpcclient.BitcoinRPCException;
import wf.bitcoin.javabitcoindrpcclient.BitcoindRpcClient;
import wf.bitcoin.krotjson.HexCoder;

public abstract class AbstractWallet
extends RpcClientSupport
implements Wallet {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final Blockchain blockchain;

    protected AbstractWallet(Blockchain blockchain, BitcoindRpcClient client) {
        super(client);
        this.blockchain = blockchain;
    }

    protected Blockchain getBlockchain() {
        return this.blockchain;
    }

    @Override
    public void importAddresses(Config config) {
        AssertArgument.assertNotNull(config, "Null config");
        for (Config.Address addr : config.getWallet().getAddresses()) {
            String privKey = addr.getPrivKey();
            String pubKey = addr.getPubKey();
            try {
                if (privKey != null && pubKey == null) {
                    this.importPrivateKey(privKey, addr.getLabels());
                    continue;
                }
                this.importAddress(pubKey, addr.getLabels());
            }
            catch (BitcoinRPCException ex) {
                String message = ex.getMessage();
                if (message.contains("walletpassphrase")) continue;
                throw ex;
            }
        }
    }

    @Override
    public Wallet.Address importPrivateKey(String privKey, List<String> labels) {
        AssertArgument.assertNotNull(privKey, "Null privKey");
        AssertArgument.assertNotNull(labels, "Null labels");
        for (Wallet.Address addr : this.getAddresses()) {
            if (!privKey.equals(addr.getPrivKey())) continue;
            return addr;
        }
        String lstr = this.concatLabels(labels);
        this.LOG.info("Import privKey {} {}", (Object)(privKey.substring(0, 2) + "************"), (Object)lstr);
        boolean rescan = !this.blockchain.isPruned();
        this.client.importPrivKey(privKey, lstr, rescan);
        Wallet.Address addr = null;
        for (Wallet.Address aux : this.getAddresses()) {
            if (!privKey.equals(aux.getPrivKey())) continue;
            addr = aux;
            break;
        }
        AssertState.assertNotNull(addr, "Cannot get imported address from wallet");
        return addr;
    }

    @Override
    public Wallet.Address importAddress(String rawAddr, List<String> labels) {
        AssertArgument.assertNotNull(rawAddr, "Null privKey");
        AssertArgument.assertNotNull(labels, "Null labels");
        for (Wallet.Address addr : this.getAddresses()) {
            if (!rawAddr.equals(addr.getAddress())) continue;
            return addr;
        }
        String lstr = this.concatLabels(labels);
        this.LOG.info("Import address {} {}", (Object)rawAddr, (Object)lstr);
        boolean rescan = !this.blockchain.isPruned();
        this.client.importAddress(rawAddr, lstr, rescan);
        return this.fromRawAddress(rawAddr, labels);
    }

    public String getPrivKey(String addr) {
        String privKey = null;
        try {
            privKey = this.client.dumpPrivKey(addr);
        }
        catch (BitcoinRPCException bitcoinRPCException) {
            // empty catch block
        }
        return privKey;
    }

    @Override
    public final Wallet.Address newAddress(String label) {
        AssertArgument.assertNotNull(label, "Null label");
        return this.createNewAddress(Arrays.asList(label));
    }

    @Override
    public final Wallet.Address newChangeAddress(String label) {
        AssertArgument.assertNotNull(label, "Null label");
        return this.createNewAddress(Arrays.asList(label, "(change)"));
    }

    @Override
    public Wallet.Address getAddress(String label) {
        AssertArgument.assertNotNull(label, "Null label");
        List<Wallet.Address> addrs = this.getAddresses(label);
        addrs = addrs.stream().filter(a -> !a.getLabels().contains("(change)")).collect(Collectors.toList());
        return addrs != null && addrs.size() > 0 ? addrs.iterator().next() : null;
    }

    @Override
    public Wallet.Address findAddress(String rawAddr) {
        AssertArgument.assertNotNull(rawAddr, "Null rawAddr");
        return this.getAddresses().stream().filter(a -> a.getAddress().equals(rawAddr)).findFirst().orElse(null);
    }

    @Override
    public List<Wallet.Address> getAddresses(String label) {
        AssertArgument.assertNotNull(label, "Null label");
        List<Wallet.Address> filtered = this.getAddresses().stream().filter(a -> a.getLabels().contains(label)).collect(Collectors.toList());
        return filtered;
    }

    @Override
    public List<Wallet.Address> getChangeAddresses(String label) {
        AssertArgument.assertNotNull(label, "Null label");
        List<Wallet.Address> filtered = this.getAddresses(label).stream().filter(a -> a.getLabels().contains("(change)")).collect(Collectors.toList());
        return filtered;
    }

    @Override
    public Wallet.Address getChangeAddress(String label) {
        AssertArgument.assertNotNull(label, "Null label");
        List<Wallet.Address> addrs = this.getChangeAddresses(label);
        if (addrs.isEmpty()) {
            addrs.add(this.newChangeAddress(label));
        }
        if (addrs.size() == 1) {
            return addrs.get(0);
        }
        int idx = new Random().nextInt(addrs.size());
        return addrs.get(idx);
    }

    @Override
    public BigDecimal getBalance(String label) {
        List<Wallet.Address> addrs = label != null ? this.getAddresses(label) : this.getAddresses();
        return AbstractWallet.getUTXOAmount(this.listUnspent(addrs));
    }

    @Override
    public BigDecimal getBalance(Wallet.Address addr) {
        AssertArgument.assertNotNull(addr, "Null addr");
        return AbstractWallet.getUTXOAmount(this.listUnspent(Arrays.asList(addr)));
    }

    public static BigDecimal getUTXOAmount(List<UTXO> utxos) {
        AssertArgument.assertNotNull(utxos, "Null utxos");
        BigDecimal result = BigDecimal.ZERO;
        for (UTXO utxo : utxos) {
            result = result.add(utxo.getAmount());
        }
        return result;
    }

    @Override
    public String sendToAddress(String toAddr, BigDecimal amount) {
        AssertArgument.assertNotNull(toAddr, "Null toAddr");
        AssertArgument.assertNotNull(amount, "Null amount");
        return this.client.sendToAddress(toAddr, amount);
    }

    @Override
    public String sendFromAddress(Wallet.Address fromAddr, String toAddr, BigDecimal amount) {
        AssertArgument.assertNotNull(fromAddr, "Null fromAddr");
        AssertArgument.assertNotNull(toAddr, "Null toAddr");
        AssertArgument.assertNotNull(amount, "Null amount");
        List<String> labels = fromAddr.getLabels();
        AssertState.assertTrue(labels.size() > 0, "No labels on: " + fromAddr);
        List<UTXO> utxos = this.selectUnspent(Arrays.asList(fromAddr), amount);
        String changeAddr = this.getChangeAddress(labels.get(0)).getAddress();
        return this.sendToAddress(toAddr, changeAddr, amount, utxos);
    }

    @Override
    public String sendFromLabel(String label, String toAddr, BigDecimal amount) {
        AssertArgument.assertNotNull(label, "Null label");
        AssertArgument.assertNotNull(toAddr, "Null toAddr");
        AssertArgument.assertNotNull(amount, "Null amount");
        List<UTXO> utxos = this.selectUnspent(label, amount);
        String changeAddr = this.getChangeAddress(label).getAddress();
        return this.sendToAddress(toAddr, changeAddr, amount, utxos);
    }

    @Override
    public String sendToAddress(String toAddr, String changeAddr, BigDecimal amount, List<UTXO> utxos) {
        AssertArgument.assertNotNull(toAddr, "Null toAddr");
        AssertArgument.assertNotNull(changeAddr, "Null changeAddr");
        AssertArgument.assertNotNull(amount, "Null amount");
        AssertArgument.assertNotNull(utxos, "Null utxos");
        if (utxos.isEmpty()) {
            return null;
        }
        List utxoWithoutSPK = utxos.stream().filter(utxo -> utxo.getScriptPubKey() == null).collect(Collectors.toList());
        if (!utxoWithoutSPK.isEmpty()) {
            List<Wallet.Address> addrs = utxos.stream().map(utxo -> utxo.getAddress()).map(raw -> this.findAddress((String)raw)).distinct().collect(Collectors.toList());
            List<UTXO> futxos = utxos;
            List utxoWithSPK = this.listUnspent(addrs).stream().filter(utxo -> futxos.contains(utxo)).collect(Collectors.toList());
            AssertState.assertEquals(utxos, utxoWithSPK);
            utxos = utxoWithSPK;
        }
        Network network = this.blockchain.getNetwork();
        BigDecimal dustAmount = network.getDustThreshold();
        BigDecimal utxosAmount = AbstractWallet.getUTXOAmount(utxos);
        BigDecimal sendAmount = utxosAmount.subtract(network.getMinTxFee());
        BigDecimal changeAmount = BigDecimal.ZERO;
        AssertState.assertTrue(sendAmount.doubleValue() <= utxosAmount.doubleValue(), "Cannot find sufficient funds");
        if (sendAmount.doubleValue() <= dustAmount.doubleValue()) {
            this.LOG.debug(String.format("UTXO Amount: %.6f", utxosAmount));
            this.LOG.debug(String.format("Send Amount: %.6f", sendAmount));
            this.LOG.warn("Cannot send less than dust amount: {}", (Object)sendAmount);
            return null;
        }
        Tx tmpTx = new Tx.TxBuilder().unspentInputs(utxos).output(toAddr, sendAmount).build();
        byte[] bytes = HexCoder.decode((String)this.createRawTx(tmpTx));
        double kbytes = new Double(bytes.length) / 1024.0;
        BigDecimal feePerKB = network.estimateSmartFee(null);
        BigDecimal smartFee = new BigDecimal(String.format("%.6f", feePerKB.doubleValue() * kbytes));
        BigDecimal feeAmount = smartFee.max(network.getMinTxFee());
        this.LOG.debug(String.format("Smart Fee: %.6f", smartFee));
        this.LOG.debug(String.format("MinTx Fee: %.6f", network.getMinTxFee()));
        this.LOG.debug(String.format("Final Fee: %d bytes => %.6f", bytes.length, feeAmount));
        if (amount == ALL_FUNDS) {
            sendAmount = utxosAmount.subtract(feeAmount);
            changeAmount = BigDecimal.ZERO;
        } else {
            changeAmount = utxosAmount.subtract(sendAmount);
            changeAmount = changeAmount.subtract(feeAmount);
        }
        this.LOG.debug(String.format("UTXO Amount: %.6f", utxosAmount));
        this.LOG.debug(String.format("Send Amount: %.6f", sendAmount));
        this.LOG.debug(String.format("Change Amount: %.6f", changeAmount));
        Tx.TxBuilder builder = new Tx.TxBuilder().unspentInputs(utxos).output(toAddr, sendAmount);
        if (dustAmount.compareTo(changeAmount) < 0) {
            builder.output(changeAddr, changeAmount);
        }
        Tx tx = builder.build();
        String txId = this.sendTx(tx);
        this.LOG.debug("txId: {}", (Object)txId);
        return txId;
    }

    @Override
    public String sendTx(Tx tx) {
        AssertArgument.assertNotNull(tx, "Null tx");
        String rawTx = this.createRawTx(tx);
        String signedTx = this.signRawTx(rawTx, tx.inputs());
        return this.sendRawTransaction(signedTx);
    }

    public String createRawTx(Tx tx) {
        AssertArgument.assertNotNull(tx, "Null tx");
        List<BitcoindRpcClient.TxInput> auxIns = this.adaptInputs(tx.inputs());
        List<BitcoindRpcClient.TxOutput> auxOuts = this.adaptOutputs(tx.outputs());
        return this.client.createRawTransaction(auxIns, auxOuts);
    }

    public String signRawTx(String rawTx, List<TxInput> inputs) {
        AssertArgument.assertNotNull(rawTx, "Null rawTx");
        AssertArgument.assertNotNull(inputs, "Null inputs");
        ArrayList<String> privKeys = new ArrayList<String>();
        for (TxInput txin : inputs) {
            UTXO utxo = (UTXO)txin;
            String privKey = this.getPrivKey(utxo.getAddress());
            privKeys.add(privKey);
        }
        return this.client.signRawTransaction(rawTx, this.adaptInputs(inputs), privKeys);
    }

    public String sendRawTransaction(String signedTx) {
        AssertArgument.assertNotNull(signedTx, "Null signedTx");
        return this.client.sendRawTransaction(signedTx);
    }

    @Override
    public List<UTXO> listUnspent(String label) {
        AssertArgument.assertNotNull(label, "Null label");
        return this.listUnspent(this.getAddresses(label));
    }

    @Override
    public List<UTXO> listUnspent(List<Wallet.Address> addrs) {
        AssertArgument.assertNotNull(addrs, "Null addrs");
        ArrayList<UTXO> result = new ArrayList<UTXO>();
        if (!addrs.isEmpty()) {
            List<String> rawAddrs = this.getRawAddresses(addrs);
            for (BitcoindRpcClient.Unspent unspnt : this.client.listUnspent(0, Integer.MAX_VALUE, rawAddrs.toArray(new String[addrs.size()]))) {
                String txId = unspnt.txid();
                Integer vout = unspnt.vout();
                String addr = unspnt.address();
                String scriptPubKey = unspnt.scriptPubKey();
                BigDecimal amount = unspnt.amount();
                result.add(new UTXO(txId, vout, scriptPubKey, addr, amount));
            }
        }
        return result;
    }

    @Override
    public List<UTXO> listLockUnspent(List<Wallet.Address> addrs) {
        AssertArgument.assertNotNull(addrs, "Null addrs");
        ArrayList<UTXO> result = new ArrayList<UTXO>();
        List<String> rawAddrs = this.getRawAddresses(addrs);
        for (BitcoindRpcClient.LockedUnspent unspnt : this.client.listLockUnspent()) {
            TxOutput txout;
            String rawAddr;
            String txId = unspnt.txId();
            Integer vout = unspnt.vout();
            Tx tx = this.getLockedTransaction(txId);
            if (tx == null || !rawAddrs.contains(rawAddr = (txout = tx.outputs().get(vout)).getAddress())) continue;
            BigDecimal amount = txout.getAmount();
            result.add(new UTXO(txId, vout, null, rawAddr, amount));
        }
        return result;
    }

    protected Tx getLockedTransaction(String txId) {
        return this.getTransaction(txId);
    }

    @Override
    public boolean lockUnspent(UTXO utxo, boolean unlock) {
        AssertArgument.assertNotNull(utxo, "Null utxo");
        String act = unlock ? "unlock" : "lock";
        String txId = utxo.getTxId();
        Integer vout = utxo.getVout();
        this.LOG.debug(String.format("UTXO %s: %s %d", act, txId, vout));
        return this.client.lockUnspent(unlock, txId, vout.intValue());
    }

    @Override
    public List<UTXO> selectUnspent(String label, BigDecimal amount) {
        AssertArgument.assertNotNull(label, "Null label");
        AssertArgument.assertNotNull(amount, "Null amount");
        List<Wallet.Address> addrs = this.getAddresses(label);
        return this.selectUnspent(addrs, amount);
    }

    @Override
    public List<UTXO> selectUnspent(List<Wallet.Address> addrs, BigDecimal amount) {
        AssertArgument.assertNotNull(addrs, "Null addrs");
        AssertArgument.assertNotNull(amount, "Null amount");
        BigDecimal total = BigDecimal.ZERO;
        ArrayList<UTXO> result = new ArrayList<UTXO>();
        for (UTXO utxo : this.listUnspent(addrs)) {
            result.add(utxo);
            total = total.add(utxo.getAmount());
            if (amount == ALL_FUNDS || amount.compareTo(total) > 0) continue;
            break;
        }
        AssertState.assertTrue(amount.compareTo(total) <= 0, "Insufficient funds: " + total);
        return result;
    }

    @Override
    public Tx getTransaction(String txId) {
        AssertArgument.assertNotNull(txId, "Null txId");
        BitcoindRpcClient.Transaction transaction = this.client.getTransaction(txId);
        Tx.TxBuilder builder = new Tx.TxBuilder();
        builder.txId(transaction.txId());
        builder.blockHash(transaction.blockHash());
        builder.blockTime(transaction.blockTime());
        BitcoindRpcClient.RawTransaction rawTx = transaction.raw();
        if (rawTx != null) {
            for (BitcoindRpcClient.RawTransaction.In in : rawTx.vIn()) {
                TxInput txIn = new TxInput(in.txid(), in.vout(), in.scriptPubKey());
                builder.input(txIn);
            }
            for (BitcoindRpcClient.RawTransaction.Out out : rawTx.vOut()) {
                BitcoindRpcClient.RawTransaction.Out.ScriptPubKey spk = out.scriptPubKey();
                List addrs = spk.addresses();
                String addr = null;
                if (addrs != null && addrs.size() > 0) {
                    if (addrs.size() > 1) {
                        this.LOG.warn("Multiple addresses not supported");
                    }
                    addr = (String)addrs.get(0);
                }
                byte[] data = null;
                String hex = spk.hex();
                String type = spk.type();
                byte op = HexCoder.decode((String)hex.substring(0, 2))[0];
                if (op == 106) {
                    data = HexCoder.decode((String)hex);
                }
                TxOutput txOut = new TxOutput(addr, out.value(), data);
                txOut.setType(type);
                builder.output(txOut);
            }
        }
        Tx txres = builder.build();
        return txres;
    }

    public String redeemChange(String label, Wallet.Address toAddr) {
        AssertArgument.assertNotNull(label, "Null label");
        AssertArgument.assertNotNull(toAddr, "Null toAddr");
        List<Wallet.Address> addrs = this.getChangeAddresses(label);
        List<UTXO> utxos = this.listUnspent(addrs);
        return this.sendToAddress(toAddr.getAddress(), toAddr.getAddress(), Wallet.ALL_FUNDS, utxos);
    }

    public abstract Wallet.Address fromRawAddress(String var1, List<String> var2);

    public abstract Wallet.Address createNewAddress(List<String> var1);

    public String concatLabels(List<String> labels) {
        String result = labels.toString();
        return result.substring(1, result.length() - 1);
    }

    public List<String> splitLabels(String labels) {
        return Arrays.asList(labels.split(",")).stream().map(t -> t.trim()).collect(Collectors.toList());
    }

    private List<String> getRawAddresses(List<Wallet.Address> addrs) {
        return addrs.stream().map(a -> a.getAddress()).collect(Collectors.toList());
    }

    private List<BitcoindRpcClient.TxInput> adaptInputs(List<TxInput> inputs) {
        ArrayList<BitcoindRpcClient.TxInput> result = new ArrayList<BitcoindRpcClient.TxInput>();
        for (TxInput aux : inputs) {
            result.add((BitcoindRpcClient.TxInput)new BitcoindRpcClient.BasicTxInput(aux.getTxId(), aux.getVout(), aux.getScriptPubKey()));
        }
        return result;
    }

    private List<BitcoindRpcClient.TxOutput> adaptOutputs(List<TxOutput> outputs) {
        ArrayList<BitcoindRpcClient.TxOutput> result = new ArrayList<BitcoindRpcClient.TxOutput>();
        for (TxOutput aux : outputs) {
            result.add((BitcoindRpcClient.TxOutput)new BitcoindRpcClient.BasicTxOutput(aux.getAddress(), aux.getAmount(), aux.getData()));
        }
        return result;
    }
}

