/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.testing;

import io.nessus.AbstractWallet;
import io.nessus.Blockchain;
import io.nessus.Config;
import io.nessus.Network;
import io.nessus.UTXO;
import io.nessus.Wallet;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBlockchainTest {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    public static final String LABEL_BOB = "Bob";
    public static final String LABEL_MARY = "Mary";
    public static final String LABEL_SINK = "";
    public static final String ADDRESS_BOB = "n3ha6rJa8ZS7B4v4vwNWn8CnLHfUYXW1XE";
    public static final String ADDRESS_MARY = "mm2PoHeFncAStYeZJSSTa4bmUVXRa3L6PL";
    protected static Blockchain blockchain;
    protected static Network network;
    protected static Wallet wallet;
    protected static Wallet.Address addrBob;
    protected static Wallet.Address addrMary;
    protected static Wallet.Address addrSink;

    @Before
    public void before() throws Exception {
        if (blockchain == null) {
            blockchain = this.getBlockchain();
            network = blockchain.getNetwork();
            wallet = blockchain.getWallet();
            addrSink = wallet.getAddress(LABEL_SINK);
            if (addrSink == null) {
                addrSink = wallet.newAddress(LABEL_SINK);
            }
            this.importAddresses(this.getClass());
            BigDecimal balance = wallet.getBalance(addrSink);
            if (BigDecimal.ZERO.compareTo(balance) <= 0) {
                this.generate(101, addrSink);
            }
            addrBob = wallet.findAddress(ADDRESS_BOB);
            addrMary = wallet.findAddress(ADDRESS_MARY);
            List<Wallet.Address> addrs = wallet.getAddresses();
            wallet.listLockUnspent(addrs).forEach(utxo -> wallet.lockUnspent((UTXO)utxo, true));
            List<UTXO> utxos = wallet.listUnspent(addrs);
            if (!utxos.isEmpty()) {
                String rawSink = addrSink.getAddress();
                wallet.sendToAddress(rawSink, rawSink, Wallet.ALL_FUNDS, utxos);
                this.generate(1, addrSink);
            }
        }
    }

    protected abstract Blockchain createBlockchain();

    protected Blockchain getBlockchain() {
        if (blockchain == null) {
            blockchain = this.createBlockchain();
        }
        return blockchain;
    }

    protected void importAddresses(Class<?> configSource) throws IOException {
        URL configURL = configSource.getResource("/initial-import.json");
        if (configURL != null) {
            Config config = Config.parseConfig(configURL);
            wallet.importAddresses(config);
        }
    }

    protected void generate(int blocks, Wallet.Address addr) {
        List<String> hashs = network.generate(blocks, addr);
        Assert.assertEquals((long)blocks, (long)hashs.size());
    }

    protected BigDecimal getUTXOAmount(List<UTXO> utxos) {
        return AbstractWallet.getUTXOAmount(utxos);
    }

    protected void showAccountBalances() {
        HashMap groups = new HashMap();
        wallet.getAddresses().forEach(addr -> addr.getLabels().stream().filter(lb -> !"(change)".equals(lb)).forEach(lb -> {
            ArrayList<Wallet.Address> list = (ArrayList<Wallet.Address>)groups.get(lb);
            if (list == null) {
                list = new ArrayList<Wallet.Address>();
                groups.put(lb, list);
            }
            list.add((Wallet.Address)addr);
        }));
        for (String label : groups.keySet().stream().sorted().collect(Collectors.toList())) {
            Double val = ((List)groups.get(label)).stream().mapToDouble(addr -> wallet.getBalance((Wallet.Address)addr).doubleValue()).sum();
            this.LOG.info(String.format("%-5s: %13.8f", label, val));
        }
    }
}

